/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.gradle;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.impl.gradle.GradleEffectiveDependencies;
import org.jboss.shrinkwrap.resolver.impl.gradle.GradleRunner;
import org.jboss.shrinkwrap.resolver.impl.gradle.ScopeType;

public class GradleStrategyStage {
    private final String projectDirectory;
    private final Set<ScopeType> scopeTypesDependencies;

    public GradleStrategyStage(String projectDirectory, Set<ScopeType> scopeTypesDependencies) {
        this.projectDirectory = projectDirectory;
        this.scopeTypesDependencies = scopeTypesDependencies;
    }

    public Archive[] as(Class<? extends Archive> archive) {
        List<? extends Archive> archives = this.asList(archive);
        return archives.toArray(new Archive[archives.size()]);
    }

    public List<? extends Archive> asList(Class<? extends Archive> archive) {
        ArrayList<Archive> archives = new ArrayList<Archive>();
        GradleEffectiveDependencies gradleEffectiveDependencies = GradleRunner.getEffectiveDependencies(this.projectDirectory);
        for (ScopeType scopeType : this.scopeTypesDependencies) {
            List<File> dependenciesByScope = gradleEffectiveDependencies.getDependenciesByScope(scopeType);
            for (File dependency : dependenciesByScope) {
                Archive dep = (Archive)((ZipImporter)((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)dependency.getName())).importFrom(dependency)).as(archive);
                archives.add(dep);
            }
        }
        return archives;
    }
}

