/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPackagingProcessor
extends AbstractCompilingProcessor<JavaArchive>
implements PackagingProcessor<JavaArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-jar-plugin";
    private JavaArchive archive;

    public boolean handles(PackagingType packagingType) {
        return PackagingType.JAR.equals((Object)packagingType);
    }

    public JarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)session.getParsedPomFile().getFinalName());
        return this;
    }

    public JarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws ResolutionException, IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"sources.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (JavaArchive)this.archive.merge((Archive)classes);
        }
        for (File resource : pomFile.getProjectResources()) {
            this.archive.addAsResource(resource);
        }
        return this;
    }

    public JavaArchive getResultingArchive() {
        return this.archive;
    }
}

