/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.importer;

import java.io.File;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.resolver.api.InvalidConfigurationFileException;
import org.jboss.shrinkwrap.resolver.api.Resolvers;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolverSystem;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporter;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.PomEquippedMavenImporter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.importer.PomEquippedMavenImporterImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.task.InferPackagingTypeTask;
import org.jboss.shrinkwrap.resolver.impl.maven.task.LoadPomDependenciesTask;
import org.jboss.shrinkwrap.resolver.impl.maven.task.LoadPomTask;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImporterImpl
implements MavenImporter {
    private MavenWorkingSession session;
    private Archive<?> archive;

    public MavenImporterImpl(Archive<?> archive) {
        Resolvers.use(MavenResolverSystem.class);
        this.session = new MavenWorkingSessionImpl();
        this.archive = archive;
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> type) {
        throw new UnsupportedOperationException("There were no data imported yet. Please load a pom file first using any of the loadPomFrom*() methods.");
    }

    public PomEquippedMavenImporter loadPomFromFile(File pomFile) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromFile((File)pomFile, (String[])new String[0]).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromFile(File pomFile, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromFile((File)pomFile, (String[])profiles).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromFile(String pathToPomFile) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromFile((String)pathToPomFile, (String[])new String[0]).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromFile(String pathToPomFile, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromFile((String)pathToPomFile, (String[])profiles).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromClassLoaderResource(String pathToPomResource) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromClassLoaderResource((String)pathToPomResource).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromClassLoaderResource((String)pathToPomResource, (ClassLoader)cl).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }

    public PomEquippedMavenImporter loadPomFromClassLoaderResource(String pathToPomResource, ClassLoader cl, String ... profiles) throws IllegalArgumentException, InvalidConfigurationFileException {
        this.session = LoadPomTask.loadPomFromClassLoaderResource((String)pathToPomResource, (ClassLoader)cl, (String[])profiles).execute(this.session);
        this.session = LoadPomDependenciesTask.INSTANCE.execute(this.session);
        PackagingType packagingType = InferPackagingTypeTask.INSTANCE.execute(this.session);
        PackagingProcessor processor = PackagingProcessors.find((PackagingType)packagingType);
        processor.configure(this.archive, this.session);
        return new PomEquippedMavenImporterImpl(processor);
    }
}

