/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.codehaus.plexus.util.AbstractScanner;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.pom.ParsedPomFile;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.archive.packaging.AbstractCompilingProcessor;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.jboss.shrinkwrap.resolver.spi.maven.archive.packaging.PackagingProcessor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarPackagingProcessor
extends AbstractCompilingProcessor<JavaArchive>
implements PackagingProcessor<JavaArchive> {
    public static final String MAVEN_WAR_PLUGIN_KEY = "org.apache.maven.plugins:maven-jar-plugin";
    private JavaArchive archive;

    public boolean handles(PackagingType packagingType) {
        return PackagingType.JAR.equals((Object)packagingType);
    }

    public JarPackagingProcessor configure(Archive<?> archive, MavenWorkingSession session) {
        super.configure(session);
        this.archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)session.getParsedPomFile().getFinalName());
        return this;
    }

    public JarPackagingProcessor importBuildOutput(MavenResolutionStrategy strategy) throws ResolutionException, IllegalArgumentException, UnsupportedOperationException {
        ParsedPomFile pomFile = this.session.getParsedPomFile();
        if (Validate.isReadable((File)pomFile.getSourceDirectory())) {
            this.compile(pomFile.getSourceDirectory(), pomFile.getBuildOutputDirectory(), ScopeType.COMPILE, ScopeType.IMPORT, ScopeType.PROVIDED, ScopeType.RUNTIME, ScopeType.SYSTEM);
            JavaArchive classes = (JavaArchive)((ExplodedImporter)ShrinkWrap.create(ExplodedImporter.class, (String)"sources.jar")).importDirectory(pomFile.getBuildOutputDirectory()).as(JavaArchive.class);
            this.archive = (JavaArchive)this.archive.merge((Archive)classes);
        }
        Map jarConfiguration = pomFile.getPluginConfiguration(MAVEN_WAR_PLUGIN_KEY);
        ListFilter listFilter = new ListFilter();
        String[] includes = this.getIncludes(jarConfiguration);
        listFilter.setExcludes(this.getExcludes(jarConfiguration));
        listFilter.addDefaultExcludes();
        if (includes == null || includes.length == 0) {
            listFilter.setIncludes(DEFAULT_INCLUDES);
        } else {
            listFilter.setIncludes(includes);
        }
        for (File resource : listFilter.scan(pomFile.getProjectResources(), pomFile.getBaseDirectory())) {
            this.archive.addAsResource(resource);
        }
        return this;
    }

    public JavaArchive getResultingArchive() {
        return this.archive;
    }

    @Override
    protected String[] getExcludes(Map<String, Object> configuration) {
        List<String> excludes = this.extractExcludes(configuration, "excludes", "exclude");
        return excludes.toArray(new String[excludes.size()]);
    }

    @Override
    protected String[] getIncludes(Map<String, Object> configuration) {
        List<String> includes = this.extractExcludes(configuration, "includes", "include");
        return includes.toArray(new String[includes.size()]);
    }

    private List<String> extractExcludes(Map<String, Object> configuration, String groupKey, String itemKey) {
        ArrayList<String> items = new ArrayList<String>();
        Map configExcludes = (Map)configuration.get(groupKey);
        if (configExcludes == null) {
            return items;
        }
        Object exclude = configExcludes.get(itemKey);
        if (exclude instanceof Iterable) {
            for (Object excludeItem : (Iterable)exclude) {
                JarPackagingProcessor.addTokenized(items, excludeItem);
            }
        } else {
            JarPackagingProcessor.addTokenized(items, exclude);
        }
        return items;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListFilter
    extends AbstractScanner {
        private ListFilter() {
        }

        public List<File> scan(Iterable<File> newfiles, File root) {
            this.setupDefaultFilters();
            ArrayList<File> includedFiles = new ArrayList<File>();
            int rootPathLength = root.getAbsolutePath().length();
            for (File file : newfiles) {
                String name = file.getAbsolutePath().substring(rootPathLength + 1);
                if (!file.isFile() || !this.isIncluded(name) || this.isExcluded(name)) continue;
                includedFiles.add(file);
            }
            return includedFiles;
        }

        public void scan() {
            throw new UnsupportedOperationException();
        }

        public String[] getIncludedFiles() {
            throw new UnsupportedOperationException();
        }

        public String[] getIncludedDirectories() {
            throw new UnsupportedOperationException();
        }

        public File getBasedir() {
            throw new UnsupportedOperationException();
        }
    }
}

