/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.api.DependencyResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.AcceptAllFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.ArtifactAsKey;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverInternal;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.Validate;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuilderImpl
implements MavenDependencyResolverInternal {
    private static final Logger log = Logger.getLogger(MavenArtifactBuilderImpl.class.getName());
    private static final File[] FILE_CAST = new File[0];
    private final MavenRepositorySystem system = new MavenRepositorySystem();
    private final MavenDependencyResolverSettings settings = new MavenDependencyResolverSettings();
    private RepositorySystemSession session;
    Stack<MavenDependency> dependencies = new Stack();
    Map<ArtifactAsKey, MavenDependency> pomInternalDependencyManagement = new HashMap<ArtifactAsKey, MavenDependency>();

    @Override
    public Stack<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Map<ArtifactAsKey, MavenDependency> getPomInternalDependencyManagement() {
        return this.pomInternalDependencyManagement;
    }

    public MavenBuilderImpl() {
        this.session = this.system.getSession(this.settings);
    }

    public MavenDependencyResolver configureFrom(String path) {
        Validate.isReadable(path, "Path to the settings.xml must be defined and accessible");
        this.system.loadSettings(new File(path), this.settings);
        this.session = this.system.getSession(this.settings);
        return this;
    }

    public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
        Validate.isReadable(path, "Path to the pom.xml file must be defined and accessible");
        File pom = new File(path);
        Model model = this.system.loadPom(pom, this.settings, this.session);
        ArtifactTypeRegistry stereotypes = this.system.getArtifactTypeRegistry(this.session);
        for (Dependency dependency : model.getDependencies()) {
            MavenDependency d = MavenConverter.fromDependency(dependency, stereotypes);
            this.pomInternalDependencyManagement.put(new ArtifactAsKey(d.getCoordinates()), d);
        }
        return this;
    }

    @Deprecated
    public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
        return this.loadMetadataFromPom(path);
    }

    public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
        Validate.isReadable(path, "Path to the pom.xml file must be defined and accessible");
        Model model = this.system.loadPom(new File(path), this.settings, this.session);
        ArtifactTypeRegistry stereotypes = this.system.getArtifactTypeRegistry(this.session);
        for (Dependency dependency : model.getDependencies()) {
            this.dependencies.push(MavenConverter.fromDependency(dependency, stereotypes));
        }
        return this;
    }

    @Deprecated
    public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
        return this.includeDependenciesFromPom(path);
    }

    @Deprecated
    public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
        return this.includeDependenciesFromPom(path);
    }

    public MavenDependencyResolver artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        return new MavenArtifactBuilderImpl(this, coordinates);
    }

    public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        return new MavenArtifactsBuilderImpl(this, coordinates);
    }

    public MavenDependencyResolver exclusion(String coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(new String[]{coordinates});
        return this;
    }

    public MavenDependencyResolver exclusions(String ... coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(coordinates);
        return this;
    }

    public MavenDependencyResolver exclusions(Collection<String> coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(coordinates.toArray(new String[0]));
        return this;
    }

    public MavenDependencyResolver optional(boolean optional) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.setOptional(optional);
        return this;
    }

    public MavenDependencyResolver scope(String scope) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.setScope(scope);
        return this;
    }

    public File[] resolveAsFiles() throws ResolutionException {
        return this.resolveAsFiles((MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
        Collection<ArtifactResult> artifacts;
        Validate.notEmpty(this.dependencies, "No dependencies were set for resolution");
        CollectRequest request = new CollectRequest(MavenConverter.asDependencies(this.dependencies), null, this.settings.getRemoteRepositories());
        filter.configure(Collections.unmodifiableList(this.dependencies));
        try {
            artifacts = this.system.resolveDependencies(this.session, request, filter);
        }
        catch (DependencyCollectionException e) {
            throw new ResolutionException("Unable to collect dependeny tree for a resolution", (Throwable)e);
        }
        catch (ArtifactResolutionException e) {
            throw new ResolutionException("Unable to resolve an artifact", (Throwable)e);
        }
        ArrayList<File> files = new ArrayList<File>(artifacts.size());
        for (ArtifactResult artifact : artifacts) {
            Artifact a = artifact.getArtifact();
            if ("pom".equals(a.getExtension())) {
                log.info("Removed POM artifact " + a.toString() + " from archive, it's dependencies were fetched.");
                continue;
            }
            files.add(a.getFile());
        }
        return files.toArray(FILE_CAST);
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
        return this.resolveAs(archiveView, (MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public MavenDependencyResolver useCentralRepo(boolean useCentral) {
        this.settings.setUseMavenCentral(useCentral);
        return this;
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
        if (archiveView == null) {
            throw new IllegalArgumentException("Archive view must be specified");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        File[] files = this.resolveAsFiles(filter);
        ArrayList<Assignable> archives = new ArrayList<Assignable>(files.length);
        for (File file : files) {
            Assignable archive = ((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)file.getName())).importFrom(this.convert(file)).as(archiveView);
            archives.add(archive);
        }
        return archives;
    }

    private ZipFile convert(File file) throws ResolutionException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException e) {
            throw new ResolutionException("Unable to treat dependency artifact \"" + file.getAbsolutePath() + "\" as a ZIP file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResolutionException("Unable to access artifact file at \"" + file.getAbsolutePath() + "\".", (Throwable)e);
        }
    }

    public MavenDependencyResolver goOffline() {
        this.settings.setOffline(true);
        return this;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MavenArtifactsBuilderImpl
    implements MavenDependencyResolverInternal {
        private final MavenDependencyResolverInternal delegate;
        private int size;

        MavenArtifactsBuilderImpl(MavenDependencyResolverInternal delegate, String ... coordinates) {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            this.size = coordinates.length;
            for (String coords : coordinates) {
                coords = MavenConverter.resolveArtifactVersion(delegate.getPomInternalDependencyManagement(), coords);
                MavenDependencyImpl dependency = new MavenDependencyImpl(coords);
                delegate.getDependencies().push(dependency);
            }
        }

        public MavenDependencyResolver optional(boolean optional) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.setOptional(optional));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver scope(String scope) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.setScope(scope));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusions(String ... coordinates) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(coordinates));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusions(Collection<String> coordinates) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(coordinates.toArray(new String[0])));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusion(String exclusion) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(new String[]{exclusion}));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public MavenDependencyResolver configureFrom(String path) {
            return this.delegate.configureFrom(path);
        }

        public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
            return this.delegate.loadMetadataFromPom(path);
        }

        public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
            return this.delegate.loadReposFromPom(path);
        }

        public MavenDependencyResolver artifact(String coordinates) throws ResolutionException {
            return (MavenDependencyResolver)this.delegate.artifact(coordinates);
        }

        public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
            return (MavenDependencyResolver)this.delegate.artifacts(coordinates);
        }

        public File[] resolveAsFiles() throws ResolutionException {
            return this.delegate.resolveAsFiles();
        }

        public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAsFiles((DependencyResolutionFilter)filter);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return this.delegate.resolveAs(archiveView);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAs(archiveView, (DependencyResolutionFilter)filter);
        }

        @Override
        public Stack<MavenDependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Map<ArtifactAsKey, MavenDependency> getPomInternalDependencyManagement() {
            return this.delegate.getPomInternalDependencyManagement();
        }

        public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.includeDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path, filter);
        }

        public MavenDependencyResolver useCentralRepo(boolean useCentral) {
            return this.delegate.useCentralRepo(useCentral);
        }

        public MavenDependencyResolver goOffline() {
            return this.delegate.goOffline();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MavenArtifactBuilderImpl
    implements MavenDependencyResolverInternal {
        private final MavenDependencyResolverInternal delegate;

        MavenArtifactBuilderImpl(MavenDependencyResolverInternal delegate, String coordinates) throws ResolutionException {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            coordinates = MavenConverter.resolveArtifactVersion(MavenBuilderImpl.this.pomInternalDependencyManagement, coordinates);
            MavenDependencyImpl dependency = new MavenDependencyImpl(coordinates);
            delegate.getDependencies().push(dependency);
        }

        public MavenDependencyResolver artifact(String coordinates) {
            Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
            return new MavenArtifactsBuilderImpl(this, coordinates);
        }

        public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
            Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
            return new MavenArtifactsBuilderImpl(this, coordinates);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return this.delegate.resolveAs(archiveView);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAs(archiveView, (DependencyResolutionFilter)filter);
        }

        public File[] resolveAsFiles() throws ResolutionException {
            return this.delegate.resolveAsFiles();
        }

        public MavenDependencyResolver configureFrom(String path) {
            return this.delegate.configureFrom(path);
        }

        public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAsFiles((DependencyResolutionFilter)filter);
        }

        public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
            return this.delegate.loadMetadataFromPom(path);
        }

        public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
            return this.delegate.loadReposFromPom(path);
        }

        public MavenDependencyResolver scope(String scope) {
            return this.delegate.scope(scope);
        }

        public MavenDependencyResolver optional(boolean optional) {
            return this.delegate.optional(optional);
        }

        public MavenDependencyResolver exclusion(String exclusion) {
            return this.delegate.exclusion(exclusion);
        }

        public MavenDependencyResolver exclusions(String ... exclusions) {
            return this.delegate.exclusions(exclusions);
        }

        public MavenDependencyResolver exclusions(Collection<String> exclusions) {
            return this.delegate.exclusions(exclusions);
        }

        @Override
        public Stack<MavenDependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Map<ArtifactAsKey, MavenDependency> getPomInternalDependencyManagement() {
            return this.delegate.getPomInternalDependencyManagement();
        }

        public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.includeDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path, filter);
        }

        public MavenDependencyResolver useCentralRepo(boolean useCentral) {
            return this.delegate.useCentralRepo(useCentral);
        }

        public MavenDependencyResolver goOffline() {
            return this.delegate.goOffline();
        }
    }
}

