/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import java.util.logging.Logger;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.resolver.api.DependencyResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.MavenDependencyResolver;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.filter.AcceptAllFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverInternal;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.util.ResourceUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.RepositorySystemSession;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.artifact.ArtifactTypeRegistry;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenBuilderImpl
implements MavenDependencyResolverInternal {
    private static final Logger log = Logger.getLogger(MavenBuilderImpl.class.getName());
    private static final File[] FILE_CAST = new File[0];
    private final MavenRepositorySystem system;
    private final MavenDependencyResolverSettings settings;
    private RepositorySystemSession session;
    private Stack<MavenDependency> dependencies;
    private Set<MavenDependency> versionManagement;

    @Override
    public Stack<MavenDependency> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<MavenDependency> getVersionManagement() {
        return this.versionManagement;
    }

    public MavenBuilderImpl() {
        this.system = new MavenRepositorySystem();
        this.settings = new MavenDependencyResolverSettings();
        this.dependencies = new Stack();
        this.versionManagement = new HashSet<MavenDependency>();
        this.session = this.system.getSession(this.settings);
    }

    public MavenBuilderImpl(MavenRepositorySystem system, RepositorySystemSession session, MavenDependencyResolverSettings settings, Stack<MavenDependency> dependencies, Set<MavenDependency> dependencyManagement) {
        this.system = system;
        this.session = session;
        this.settings = settings;
        this.dependencies = dependencies;
        this.versionManagement = dependencyManagement;
    }

    public MavenDependencyResolver configureFrom(String path) {
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the settings.xml ('" + path + "') must be defined and accessible");
        this.system.loadSettings(new File(resolvedPath), this.settings);
        this.session = this.system.getSession(this.settings);
        return this;
    }

    public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the pom.xml ('" + path + "')file must be defined and accessible");
        File pom = new File(resolvedPath);
        Model model = this.system.loadPom(pom, this.settings, this.session);
        ArtifactTypeRegistry stereotypes = this.system.getArtifactTypeRegistry(this.session);
        Stack<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(model.getDependencies(), stereotypes);
        this.versionManagement.addAll(pomDefinedDependencies);
        return this;
    }

    @Deprecated
    public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
        return this.loadMetadataFromPom(path);
    }

    public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the pom.xml file must be defined and accessible");
        File pom = new File(resolvedPath);
        Model model = this.system.loadPom(pom, this.settings, this.session);
        ArtifactTypeRegistry stereotypes = this.system.getArtifactTypeRegistry(this.session);
        Stack<MavenDependency> pomDefinedDependencies = MavenConverter.fromDependencies(model.getDependencies(), stereotypes);
        Collections.reverse(pomDefinedDependencies);
        this.dependencies.addAll(pomDefinedDependencies);
        return this;
    }

    @Deprecated
    public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
        return this.includeDependenciesFromPom(path);
    }

    @Deprecated
    public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
        return this.includeDependenciesFromPom(path);
    }

    public MavenDependencyResolver artifact(String coordinates) throws ResolutionException {
        Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
        return new MavenArtifactBuilderImpl(this, coordinates);
    }

    public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
        Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
        return new MavenArtifactsBuilderImpl(this, coordinates);
    }

    public MavenDependencyResolver exclusion(String coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(new String[]{coordinates});
        return this;
    }

    public MavenDependencyResolver exclusions(String ... coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(coordinates);
        return this;
    }

    public MavenDependencyResolver exclusions(Collection<String> coordinates) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.addExclusions(coordinates.toArray(new String[0]));
        return this;
    }

    public MavenDependencyResolver optional(boolean optional) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.setOptional(optional);
        return this;
    }

    public MavenDependencyResolver scope(String scope) {
        MavenDependency dependency = this.dependencies.peek();
        dependency.setScope(scope);
        return this;
    }

    public File[] resolveAsFiles() throws ResolutionException {
        return this.resolveAsFiles((MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
        Collection<ArtifactResult> artifacts;
        block6: {
            Validate.notEmpty(this.dependencies, "No dependencies were set for resolution");
            CollectRequest request = new CollectRequest(MavenConverter.asDependencies(this.dependencies), MavenConverter.asDependencies(new ArrayList<MavenDependency>(this.versionManagement)), this.settings.getRemoteRepositories());
            filter.configure(Collections.unmodifiableList(this.dependencies));
            artifacts = null;
            try {
                artifacts = this.system.resolveDependencies(this.session, request, filter);
            }
            catch (DependencyResolutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block6;
                if (cause instanceof ArtifactResolutionException) {
                    throw new ResolutionException("Unable to get artifact from the repository", cause);
                }
                if (cause instanceof DependencyCollectionException) {
                    throw new ResolutionException("Unable to collect dependency tree for given dependencies", cause);
                }
                throw new ResolutionException("Unable to collect/resolve dependency tree for a resulution", (Throwable)e);
            }
        }
        ArrayList<File> files = new ArrayList<File>(artifacts.size());
        for (ArtifactResult artifact : artifacts) {
            Artifact a = artifact.getArtifact();
            if ("pom".equals(a.getExtension())) {
                log.info("Removed POM artifact " + a.toString() + " from archive, it's dependencies were fetched.");
                continue;
            }
            files.add(a.getFile());
        }
        return files.toArray(FILE_CAST);
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
        return this.resolveAs(archiveView, (MavenResolutionFilter)AcceptAllFilter.INSTANCE);
    }

    public MavenDependencyResolver useCentralRepo(boolean useCentral) {
        this.settings.setUseMavenCentral(useCentral);
        return this;
    }

    public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
        if (archiveView == null) {
            throw new IllegalArgumentException("Archive view must be specified");
        }
        if (filter == null) {
            throw new IllegalArgumentException("Filter must be specified");
        }
        File[] files = this.resolveAsFiles(filter);
        ArrayList<Assignable> archives = new ArrayList<Assignable>(files.length);
        for (File file : files) {
            Assignable archive = ((ZipImporter)ShrinkWrap.create(ZipImporter.class, (String)file.getName())).importFrom(this.convert(file)).as(archiveView);
            archives.add(archive);
        }
        return archives;
    }

    public MavenDependencyResolver goOffline() {
        this.settings.setOffline(true);
        this.session = this.system.getSession(this.settings);
        return this;
    }

    private ZipFile convert(File file) throws ResolutionException {
        try {
            return new ZipFile(file);
        }
        catch (ZipException e) {
            throw new ResolutionException("Unable to treat dependency artifact \"" + file.getAbsolutePath() + "\" as a ZIP file", (Throwable)e);
        }
        catch (IOException e) {
            throw new ResolutionException("Unable to access artifact file at \"" + file.getAbsolutePath() + "\".", (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class MavenArtifactsBuilderImpl
    implements MavenDependencyResolverInternal {
        private final MavenDependencyResolverInternal delegate;
        private int size;

        MavenArtifactsBuilderImpl(MavenDependencyResolverInternal delegate, String ... coordinates) {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            this.size = coordinates.length;
            for (String coords : coordinates) {
                MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(delegate.getVersionManagement(), coords);
                delegate.getDependencies().push(dependency);
            }
        }

        public MavenDependencyResolver optional(boolean optional) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.setOptional(optional));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver scope(String scope) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.setScope(scope));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusions(String ... coordinates) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(coordinates));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusions(Collection<String> coordinates) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(coordinates.toArray(new String[0])));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public MavenDependencyResolver exclusion(String exclusion) {
            int i;
            ArrayList<MavenDependency> workplace = new ArrayList<MavenDependency>();
            for (i = 0; i < this.size; ++i) {
                MavenDependency dependency = this.delegate.getDependencies().pop();
                workplace.add(dependency.addExclusions(new String[]{exclusion}));
            }
            while (i > 0) {
                this.delegate.getDependencies().push((MavenDependency)workplace.get(i - 1));
                --i;
            }
            return this;
        }

        public int hashCode() {
            return this.delegate.hashCode();
        }

        public boolean equals(Object obj) {
            return this.delegate.equals(obj);
        }

        public MavenDependencyResolver configureFrom(String path) {
            return this.delegate.configureFrom(path);
        }

        public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
            return this.delegate.loadMetadataFromPom(path);
        }

        public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
            return this.delegate.loadReposFromPom(path);
        }

        public MavenDependencyResolver artifact(String coordinates) throws ResolutionException {
            return (MavenDependencyResolver)this.delegate.artifact(coordinates);
        }

        public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
            return (MavenDependencyResolver)this.delegate.artifacts(coordinates);
        }

        public File[] resolveAsFiles() throws ResolutionException {
            return this.delegate.resolveAsFiles();
        }

        public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAsFiles((DependencyResolutionFilter)filter);
        }

        public String toString() {
            return this.delegate.toString();
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return this.delegate.resolveAs(archiveView);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAs(archiveView, (DependencyResolutionFilter)filter);
        }

        @Override
        public Stack<MavenDependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Set<MavenDependency> getVersionManagement() {
            return this.delegate.getVersionManagement();
        }

        public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.includeDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path, filter);
        }

        public MavenDependencyResolver useCentralRepo(boolean useCentral) {
            return this.delegate.useCentralRepo(useCentral);
        }

        public MavenDependencyResolver goOffline() {
            return this.delegate.goOffline();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MavenArtifactBuilderImpl
    implements MavenDependencyResolverInternal {
        private final MavenDependencyResolverInternal delegate;

        MavenArtifactBuilderImpl(MavenDependencyResolverInternal delegate, String coordinates) throws ResolutionException {
            assert (delegate != null) : "Delegate must be specified";
            this.delegate = delegate;
            MavenDependency dependency = MavenConverter.asDepedencyWithVersionManagement(delegate.getVersionManagement(), coordinates);
            delegate.getDependencies().push(dependency);
        }

        public MavenDependencyResolver artifact(String coordinates) {
            Validate.notNullOrEmpty(coordinates, "Artifact coordinates must not be null or empty");
            return new MavenArtifactsBuilderImpl(this, coordinates);
        }

        public MavenDependencyResolver artifacts(String ... coordinates) throws ResolutionException {
            Validate.notNullAndNoNullValues(coordinates, "Artifacts coordinates must not be null or empty");
            return new MavenArtifactsBuilderImpl(this, coordinates);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView) throws ResolutionException {
            return this.delegate.resolveAs(archiveView);
        }

        public <ARCHIVEVIEW extends Assignable> Collection<ARCHIVEVIEW> resolveAs(Class<ARCHIVEVIEW> archiveView, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAs(archiveView, (DependencyResolutionFilter)filter);
        }

        public File[] resolveAsFiles() throws ResolutionException {
            return this.delegate.resolveAsFiles();
        }

        public MavenDependencyResolver configureFrom(String path) {
            return this.delegate.configureFrom(path);
        }

        public File[] resolveAsFiles(MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.resolveAsFiles((DependencyResolutionFilter)filter);
        }

        public MavenDependencyResolver loadMetadataFromPom(String path) throws ResolutionException {
            return this.delegate.loadMetadataFromPom(path);
        }

        public MavenDependencyResolver loadReposFromPom(String path) throws ResolutionException {
            return this.delegate.loadReposFromPom(path);
        }

        public MavenDependencyResolver scope(String scope) {
            return this.delegate.scope(scope);
        }

        public MavenDependencyResolver optional(boolean optional) {
            return this.delegate.optional(optional);
        }

        public MavenDependencyResolver exclusion(String exclusion) {
            return this.delegate.exclusion(exclusion);
        }

        public MavenDependencyResolver exclusions(String ... exclusions) {
            return this.delegate.exclusions(exclusions);
        }

        public MavenDependencyResolver exclusions(Collection<String> exclusions) {
            return this.delegate.exclusions(exclusions);
        }

        @Override
        public Stack<MavenDependency> getDependencies() {
            return this.delegate.getDependencies();
        }

        @Override
        public Set<MavenDependency> getVersionManagement() {
            return this.delegate.getVersionManagement();
        }

        public MavenDependencyResolver includeDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.includeDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path);
        }

        public MavenDependencyResolver loadDependenciesFromPom(String path, MavenResolutionFilter filter) throws ResolutionException {
            return this.delegate.loadDependenciesFromPom(path, filter);
        }

        public MavenDependencyResolver useCentralRepo(boolean useCentral) {
            return this.delegate.useCentralRepo(useCentral);
        }

        public MavenDependencyResolver goOffline() {
            return this.delegate.goOffline();
        }
    }
}

