/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.maven.model.Model;
import org.apache.maven.settings.Activation;
import org.apache.maven.settings.Mirror;
import org.apache.maven.settings.Profile;
import org.apache.maven.settings.Repository;
import org.apache.maven.settings.Settings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenSettingsBuilder;
import org.jboss.shrinkwrap.resolver.impl.maven.SecurityActions;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.util.repository.DefaultMirrorSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class MavenDependencyResolverSettings {
    private static final Logger log = Logger.getLogger(MavenDependencyResolverSettings.class.getName());
    private static final RemoteRepository MAVEN_CENTRAL = new RemoteRepository("central", "default", "http://repo1.maven.org/maven2");
    private Settings settings;
    private boolean useMavenCentral = true;
    private Collection<RemoteRepository> modelRemoteRepositories = Collections.emptyList();

    public MavenDependencyResolverSettings() {
        this.settings = new MavenSettingsBuilder().buildDefaultSettings();
    }

    public List<RemoteRepository> getRemoteRepositories() {
        if (this.isOffline()) {
            return Collections.emptyList();
        }
        List actives = this.settings.getActiveProfiles();
        LinkedHashSet<RemoteRepository> enhancedRepos = new LinkedHashSet<RemoteRepository>();
        for (Map.Entry profile : this.settings.getProfilesAsMap().entrySet()) {
            Activation activation = ((Profile)profile.getValue()).getActivation();
            if (!actives.contains(profile.getKey()) && (activation == null || !activation.isActiveByDefault())) continue;
            for (Repository repo : ((Profile)profile.getValue()).getRepositories()) {
                enhancedRepos.add(MavenConverter.asRemoteRepository(repo));
            }
        }
        enhancedRepos.addAll(this.modelRemoteRepositories);
        if (this.useMavenCentral) {
            enhancedRepos.add(MAVEN_CENTRAL);
        }
        if (this.settings.getMirrors().size() == 0) {
            return new ArrayList<RemoteRepository>(enhancedRepos);
        }
        DefaultMirrorSelector dms = new DefaultMirrorSelector();
        for (Mirror mirror : this.settings.getMirrors()) {
            dms.add(mirror.getId(), mirror.getUrl(), mirror.getLayout(), false, mirror.getMirrorOf(), mirror.getMirrorOfLayouts());
        }
        LinkedHashSet<RemoteRepository> mirroredRepos = new LinkedHashSet<RemoteRepository>();
        for (RemoteRepository repository : enhancedRepos) {
            RemoteRepository mirror = dms.getMirror(repository);
            if (mirror != null) {
                mirroredRepos.add(mirror);
                continue;
            }
            mirroredRepos.add(repository);
        }
        return new ArrayList<RemoteRepository>(mirroredRepos);
    }

    public void setModelRemoteRepositories(Model model) {
        ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
        for (org.apache.maven.model.Repository repository : model.getRepositories()) {
            repositories.add(MavenConverter.asRemoteRepository(repository));
        }
        this.modelRemoteRepositories = repositories;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    public boolean isUseMavenCentral() {
        return this.useMavenCentral;
    }

    public void setUseMavenCentral(boolean useMavenCentral) {
        this.useMavenCentral = useMavenCentral;
    }

    public boolean isOffline() {
        return this.settings.isOffline();
    }

    public void setOffline(boolean offline) {
        String goOffline = SecurityActions.getProperty("org.apache.maven.offline");
        if (goOffline != null) {
            this.settings.setOffline(Boolean.valueOf(goOffline).booleanValue());
            if (log.isLoggable(Level.FINER)) {
                log.finer("Offline settings is set via a system property. The new offline flag value is: " + this.settings.isOffline());
            }
        } else {
            this.settings.setOffline(offline);
        }
    }
}

