/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.io.File;
import org.apache.maven.model.Model;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.resolver.api.maven.MavenImporter;
import org.jboss.shrinkwrap.resolver.impl.maven.EffectivePomMavenImporterImpl;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenDependencyResolverSettings;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenPackagingType;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenRepositorySystem;
import org.jboss.shrinkwrap.resolver.impl.maven.util.ResourceUtil;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.RepositorySystemSession;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenImporterImpl
implements MavenImporter {
    private Archive<?> archive;
    private final MavenRepositorySystem system;
    private final MavenDependencyResolverSettings settings;
    private RepositorySystemSession session;

    public MavenImporterImpl(Archive<?> archive) {
        this.archive = archive;
        this.system = new MavenRepositorySystem();
        this.settings = new MavenDependencyResolverSettings();
        this.session = this.system.getSession(this.settings);
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> archiveType) {
        return (TYPE)this.archive.as(archiveType);
    }

    public MavenImporter configureFrom(String path) {
        Validate.notNullOrEmpty(path, "Path to a settings.xml file must be specified");
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the settings.xml ('" + path + "') must be defined and accessible");
        this.system.loadSettings(new File(resolvedPath), this.settings);
        this.session = this.system.getSession(this.settings);
        return this;
    }

    public MavenImporter.EffectivePomMavenImporter loadEffectivePom(String path, String ... profiles) {
        Validate.notNullOrEmpty(path, "Path to a POM file must be specified");
        String resolvedPath = ResourceUtil.resolvePathByQualifier(path);
        Validate.isReadable(resolvedPath, "Path to the pom.xml ('" + path + "')file must be defined and accessible");
        File pom = new File(resolvedPath);
        Model model = this.system.loadPom(pom, this.settings, this.session);
        MavenPackagingType mpt = MavenPackagingType.from(model.getPackaging());
        return new EffectivePomMavenImporterImpl(this.archive, mpt, model, this.system, this.settings, this.session);
    }
}

