/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.text.MessageFormat;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.ResolutionException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolveStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResolveStageBaseImpl<RESOLVESTAGETYPE extends MavenResolveStageBase<RESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>, STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenResolveStageBase<RESOLVESTAGETYPE, STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenWorkingSessionContainer {
    private static final MavenDependencyExclusion[] TYPESAFE_EXCLUSIONS_ARRAY = new MavenDependencyExclusion[0];
    private final MavenWorkingSession session;

    public ResolveStageBaseImpl(MavenWorkingSession session) {
        Validate.stateNotNull(session, "Maven Working session must not be null");
        this.session = session;
    }

    private void clearDependenciesFromSession() {
        this.session.getDependencies().clear();
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    public final STRATEGYSTAGETYPE resolve() throws IllegalStateException {
        return this.createStrategyStage();
    }

    public final STRATEGYSTAGETYPE resolve(String coordinate) throws IllegalArgumentException {
        this.clearDependenciesFromSession();
        this.addDependency(coordinate);
        return this.resolve();
    }

    public final STRATEGYSTAGETYPE resolve(String ... coordinates) throws IllegalArgumentException {
        this.clearDependenciesFromSession();
        this.addDependencies(coordinates);
        return this.resolve();
    }

    public final STRATEGYSTAGETYPE resolve(MavenDependency dependency) throws IllegalArgumentException {
        this.clearDependenciesFromSession();
        this.addDependency(dependency);
        return this.resolve();
    }

    public final STRATEGYSTAGETYPE resolve(MavenDependency ... coordinates) throws IllegalArgumentException {
        this.clearDependenciesFromSession();
        this.addDependencies(coordinates);
        return this.resolve();
    }

    public final RESOLVESTAGETYPE addDependency(MavenDependency dependency) throws IllegalArgumentException {
        if (dependency == null) {
            throw new IllegalArgumentException("dependency must be specified");
        }
        MavenDependency resolved = this.resolveDependency(dependency);
        this.session.getDependencies().add(resolved);
        return this.covarientReturn();
    }

    public final RESOLVESTAGETYPE addDependency(String coordinate) throws CoordinateParseException, IllegalArgumentException {
        if (coordinate == null || coordinate.length() == 0) {
            throw new IllegalArgumentException("Coordinate must be specified");
        }
        MavenDependency declared = MavenDependencies.createDependency((String)coordinate, null, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
        MavenDependency resolved = this.resolveDependency(declared);
        this.session.getDependencies().add(resolved);
        return this.covarientReturn();
    }

    public final RESOLVESTAGETYPE addDependencies(MavenDependency ... dependencies) throws IllegalArgumentException {
        if (dependencies == null || dependencies.length == 0) {
            throw new IllegalArgumentException("At least one coordinate must be specified");
        }
        for (MavenDependency dependency : dependencies) {
            if (dependency == null) {
                throw new IllegalArgumentException("null dependency not permitted");
            }
            MavenDependency resolved = this.resolveDependency(dependency);
            this.session.getDependencies().add(resolved);
        }
        return this.covarientReturn();
    }

    public final RESOLVESTAGETYPE addDependencies(String ... coordinates) throws CoordinateParseException, IllegalArgumentException {
        if (coordinates == null || coordinates.length == 0) {
            throw new IllegalArgumentException("At least one coordinate must be specified");
        }
        for (String coordinate : coordinates) {
            if (coordinate == null || coordinate.length() == 0) {
                throw new IllegalArgumentException("null dependency not permitted");
            }
            MavenDependency dependency = this.resolveDependency(coordinate);
            this.session.getDependencies().add(dependency);
        }
        return this.covarientReturn();
    }

    private MavenDependency resolveDependency(String coordinate) {
        assert (coordinate != null && coordinate.length() > 0) : "Coordinate is required";
        MavenCoordinate newCoordinate = MavenCoordinates.createCoordinate((String)coordinate);
        MavenDependency declared = MavenDependencies.createDependency((MavenCoordinate)newCoordinate, null, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
        MavenDependency resolved = this.resolveDependency(declared);
        return resolved;
    }

    private MavenDependency resolveDependency(MavenDependency declared) {
        String resolvedVersion = this.resolveVersion(declared);
        MavenCoordinate newCoordinate = MavenCoordinates.createCoordinate((String)declared.getGroupId(), (String)declared.getArtifactId(), (String)resolvedVersion, (PackagingType)declared.getPackaging(), (String)declared.getClassifier());
        MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)newCoordinate, (ScopeType)declared.getScope(), (boolean)declared.isOptional(), (MavenDependencyExclusion[])declared.getExclusions().toArray(TYPESAFE_EXCLUSIONS_ARRAY));
        return dependency;
    }

    protected String resolveVersion(MavenDependency dependency) throws IllegalArgumentException {
        String declaredVersion = dependency.getVersion();
        if (Validate.isNullOrEmpty(declaredVersion)) {
            throw new ResolutionException(MessageFormat.format("Unable to get version for dependency specified by {0}:, it was either null or empty.", dependency.toCanonicalForm()));
        }
        return declaredVersion;
    }

    private RESOLVESTAGETYPE covarientReturn() {
        return (RESOLVESTAGETYPE)((MavenResolveStageBase)this.getActualClass().cast(this));
    }

    protected abstract STRATEGYSTAGETYPE createStrategyStage();

    protected abstract Class<RESOLVESTAGETYPE> getActualClass();
}

