/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.filter;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.impl.maven.filter.MavenResolutionFilterInternalView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RejectDependenciesFilter
implements MavenResolutionFilterInternalView {
    private final Set<MavenDependency> bannedDependencies;

    public RejectDependenciesFilter(String ... coordinates) throws IllegalArgumentException, CoordinateParseException {
        if (coordinates == null || coordinates.length == 0) {
            throw new IllegalArgumentException("There must be at least one coordinate specified to be rejected.");
        }
        this.bannedDependencies = new HashSet<MavenDependency>(coordinates.length);
        for (String coords : coordinates) {
            MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)coords);
            MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)coordinate, (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
            this.bannedDependencies.add(dependency);
        }
    }

    @Override
    public MavenResolutionFilterInternalView setDefinedDependencies(List<MavenDependency> dependencies) {
        return this;
    }

    @Override
    public MavenResolutionFilterInternalView setDefinedDependencyManagement(List<MavenDependency> dependencyManagement) {
        return this;
    }

    public boolean accepts(MavenDependency coordinate) throws IllegalArgumentException {
        return !this.bannedDependencies.contains(coordinate);
    }
}

