/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.filter;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.impl.maven.filter.MavenResolutionFilterInternalView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScopeFilter
implements MavenResolutionFilterInternalView {
    private final Set<ScopeType> allowedScopes = EnumSet.noneOf(ScopeType.class);

    public ScopeFilter() {
        this(ScopeType.COMPILE);
    }

    public ScopeFilter(ScopeType ... scopes) {
        if (scopes.length == 0) {
            this.allowedScopes.add(ScopeType.COMPILE);
        } else {
            this.allowedScopes.addAll(Arrays.asList(scopes));
        }
    }

    @Override
    public MavenResolutionFilterInternalView setDefinedDependencies(List<MavenDependency> dependencies) {
        return this;
    }

    @Override
    public MavenResolutionFilterInternalView setDefinedDependencyManagement(List<MavenDependency> dependencyManagement) {
        return this;
    }

    public boolean accepts(MavenDependency coordinate) throws IllegalArgumentException {
        if (coordinate == null) {
            return false;
        }
        return this.allowedScopes.contains(coordinate.getScope());
    }
}

