/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.strategy;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.impl.maven.filter.ScopeFilter;

public class AcceptScopesStrategy
implements MavenResolutionStrategy {
    private static final Logger log = Logger.getLogger(AcceptScopesStrategy.class.getName());
    private final Set<ScopeType> allowedScopes = EnumSet.noneOf(ScopeType.class);

    public AcceptScopesStrategy(ScopeType ... scopes) {
        if (scopes.length == 0) {
            ScopeType defaultScope = ScopeType.COMPILE;
            if (log.isLoggable(Level.FINER)) {
                log.finer("No scopes specified; defaulting to " + defaultScope);
            }
            this.allowedScopes.add(defaultScope);
        } else {
            this.allowedScopes.addAll(Arrays.asList(scopes));
        }
    }

    public MavenResolutionFilter getPreResolutionFilter() {
        return new ScopeFilter(ScopeType.values());
    }

    public MavenResolutionFilter getResolutionFilter() {
        return new ScopeFilter(this.allowedScopes.toArray(new ScopeType[0]));
    }

    public MavenResolutionFilter getPostResolutionFilter() {
        return new ScopeFilter(this.allowedScopes.toArray(new ScopeType[0]));
    }
}

