/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven.strategy;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.filter.CombinedFilter;
import org.jboss.shrinkwrap.resolver.impl.maven.filter.MavenResolutionFilterInternalView;

public class CombinedStrategy
implements MavenResolutionStrategy {
    private final Set<MavenResolutionStrategy> strategies;

    public CombinedStrategy(MavenResolutionStrategy ... strategies) {
        if (strategies.length == 0) {
            throw new IllegalArgumentException("There must be at least one strategy for a combined strategy.");
        }
        this.strategies = new HashSet<MavenResolutionStrategy>(Arrays.asList(strategies));
    }

    public MavenResolutionFilter getPreResolutionFilter() {
        ArrayList<MavenResolutionFilter> filters = new ArrayList<MavenResolutionFilter>(this.strategies.size());
        for (MavenResolutionStrategy s : this.strategies) {
            filters.add(s.getPreResolutionFilter());
        }
        return new CombinedFilter(filters.toArray(new MavenResolutionFilterInternalView[0]));
    }

    public MavenResolutionFilter getResolutionFilter() {
        ArrayList<MavenResolutionFilter> filters = new ArrayList<MavenResolutionFilter>(this.strategies.size());
        for (MavenResolutionStrategy s : this.strategies) {
            filters.add(s.getResolutionFilter());
        }
        return new CombinedFilter(filters.toArray(new MavenResolutionFilterInternalView[0]));
    }

    public MavenResolutionFilter getPostResolutionFilter() {
        ArrayList<MavenResolutionFilter> filters = new ArrayList<MavenResolutionFilter>(this.strategies.size());
        for (MavenResolutionStrategy s : this.strategies) {
            filters.add(s.getPostResolutionFilter());
        }
        return new CombinedFilter(filters.toArray(new MavenResolutionFilterInternalView[0]));
    }
}

