/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.resolver.api.NoResolvedResultException;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStageBase;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import org.jboss.shrinkwrap.resolver.api.maven.filter.MavenResolutionFilter;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;
import org.jboss.shrinkwrap.resolver.api.maven.strategy.TransitiveStrategy;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSession;
import org.jboss.shrinkwrap.resolver.impl.maven.MavenWorkingSessionContainer;
import org.jboss.shrinkwrap.resolver.impl.maven.convert.MavenConverter;
import org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.collection.CollectRequest;
import org.sonatype.aether.collection.DependencyCollectionException;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.resolution.ArtifactResolutionException;
import org.sonatype.aether.resolution.ArtifactResult;
import org.sonatype.aether.resolution.DependencyResolutionException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MavenStrategyStageBaseImpl<STRATEGYSTAGETYPE extends MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>, FORMATSTAGETYPE extends MavenFormatStage>
implements MavenStrategyStageBase<STRATEGYSTAGETYPE, FORMATSTAGETYPE>,
MavenWorkingSessionContainer {
    private static final Logger log = Logger.getLogger(MavenStrategyStageBaseImpl.class.getName());
    private static final List<MavenDependency> EMPTY_LIST = new ArrayList<MavenDependency>(0);
    private final MavenWorkingSession session;

    public MavenStrategyStageBaseImpl(MavenWorkingSession session) {
        this.session = session;
    }

    public FORMATSTAGETYPE withTransitivity() {
        return this.using((MavenResolutionStrategy)TransitiveStrategy.INSTANCE);
    }

    public FORMATSTAGETYPE withoutTransitivity() {
        return this.using((MavenResolutionStrategy)NonTransitiveStrategy.INSTANCE);
    }

    @Override
    public MavenWorkingSession getMavenWorkingSession() {
        return this.session;
    }

    private List<MavenDependency> preFilter(MavenResolutionFilter[] filters, List<MavenDependency> dependenciesForResolution, List<MavenDependency> declaredDependencies) {
        assert (filters != null) : "Filters must be specified, even if empty";
        ArrayList<MavenDependency> filtered = new ArrayList<MavenDependency>();
        block0: for (MavenDependency candidate : declaredDependencies) {
            for (MavenResolutionFilter filter : filters) {
                if (!filter.accepts(candidate, dependenciesForResolution)) continue block0;
            }
            filtered.add(candidate);
        }
        return filtered;
    }

    public FORMATSTAGETYPE using(MavenResolutionStrategy strategy) throws IllegalArgumentException {
        Collection<ArtifactResult> artifactResults;
        block6: {
            Validate.notEmpty(this.session.getDependenciesForResolution(), "No dependencies were set for resolution");
            List<MavenDependency> depsForResolution = Collections.unmodifiableList(new ArrayList<MavenDependency>(this.session.getDependenciesForResolution()));
            List<MavenDependency> prefilteredDependencies = this.preFilter(strategy.getPreResolutionFilters(), depsForResolution, depsForResolution);
            ArrayList<MavenDependency> prefilteredDepsList = new ArrayList<MavenDependency>(prefilteredDependencies);
            ArrayList<MavenDependency> depManagement = new ArrayList<MavenDependency>(this.session.getDependencyManagement());
            List<RemoteRepository> repos = this.session.getRemoteRepositories();
            CollectRequest request = new CollectRequest(MavenConverter.asDependencies(prefilteredDepsList), MavenConverter.asDependencies(depManagement), repos);
            artifactResults = null;
            try {
                artifactResults = this.session.execute(request, strategy.getResolutionFilters());
            }
            catch (DependencyResolutionException e) {
                Throwable cause = e.getCause();
                if (cause == null) break block6;
                if (cause instanceof ArtifactResolutionException) {
                    throw new NoResolvedResultException("Unable to get artifact from the repository");
                }
                if (cause instanceof DependencyCollectionException) {
                    throw new NoResolvedResultException("Unable to collect dependency tree for given dependencies");
                }
                throw new NoResolvedResultException("Unable to collect/resolve dependency tree for a resulution");
            }
        }
        RestrictPomArtifactFilter postResolutionFilter = RestrictPomArtifactFilter.INSTANCE;
        ArrayList<Artifact> filteredArtifacts = new ArrayList<Artifact>();
        ArrayList<Artifact> artifactsToFilter = new ArrayList<Artifact>();
        for (ArtifactResult result : artifactResults) {
            artifactsToFilter.add(result.getArtifact());
        }
        for (Artifact artifact : artifactsToFilter) {
            MavenCoordinate coordinate = MavenCoordinates.createCoordinate((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion(), (PackagingType)PackagingType.fromPackagingType((String)artifact.getExtension()), (String)artifact.getClassifier());
            MavenDependency dependency = MavenDependencies.createDependency((MavenCoordinate)coordinate, (ScopeType)ScopeType.COMPILE, (boolean)false, (MavenDependencyExclusion[])new MavenDependencyExclusion[0]);
            if (!postResolutionFilter.accepts(dependency, EMPTY_LIST)) continue;
            filteredArtifacts.add(artifact);
        }
        return this.createFormatStage(filteredArtifacts);
    }

    public STRATEGYSTAGETYPE offline(boolean offline) {
        this.session.setOffline(offline);
        return this.covarientReturn();
    }

    public STRATEGYSTAGETYPE offline() {
        return this.offline(true);
    }

    public STRATEGYSTAGETYPE withClassPathResolution(boolean useClassPathResolution) {
        if (!useClassPathResolution) {
            this.session.disableClassPathWorkspaceReader();
        }
        return this.covarientReturn();
    }

    public STRATEGYSTAGETYPE withMavenCentralRepo(boolean useMavenCentral) {
        if (!useMavenCentral) {
            this.session.disableMavenCentral();
        }
        return this.covarientReturn();
    }

    private STRATEGYSTAGETYPE covarientReturn() {
        return (STRATEGYSTAGETYPE)((MavenStrategyStageBase)this.getActualClass().cast(this));
    }

    protected abstract Class<STRATEGYSTAGETYPE> getActualClass();

    protected abstract FORMATSTAGETYPE createFormatStage(Collection<Artifact> var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum RestrictPomArtifactFilter implements MavenResolutionFilter
    {
        INSTANCE;


        public boolean accepts(MavenDependency coordinate, List<MavenDependency> dependenciesForResolution) throws IllegalArgumentException {
            if (PackagingType.POM.equals((Object)coordinate.getPackaging())) {
                if (log.isLoggable(Level.FINER)) {
                    log.finer("Filtering out POM dependency resolution: " + coordinate + "; its transitive dependencies will be included");
                }
                return false;
            }
            return true;
        }
    }
}

