/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.Arrays;
import java.util.List;
import org.jboss.shrinkwrap.resolver.api.maven.MavenArtifactInfo;
import org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MavenArtifactInfoImpl
implements MavenArtifactInfo {
    protected final MavenCoordinate mavenCoordinate;
    protected final String resolvedVersion;
    protected final boolean snapshotVersion;
    protected final String extension;
    protected final MavenArtifactInfo[] dependencies;

    protected MavenArtifactInfoImpl(MavenCoordinate mavenCoordinate, String resolvedVersion, boolean snapshotVersion, String extension, MavenArtifactInfo[] dependencies) {
        this.mavenCoordinate = mavenCoordinate;
        this.resolvedVersion = resolvedVersion;
        this.snapshotVersion = snapshotVersion;
        this.extension = extension;
        this.dependencies = (MavenArtifactInfo[])dependencies.clone();
    }

    protected MavenArtifactInfoImpl(Artifact artifact, List<DependencyNode> children) {
        this.mavenCoordinate = MavenCoordinates.createCoordinate((String)artifact.getGroupId(), (String)artifact.getArtifactId(), (String)artifact.getBaseVersion(), (PackagingType)PackagingType.of((String)artifact.getExtension()), (String)artifact.getClassifier());
        this.resolvedVersion = artifact.getVersion();
        this.snapshotVersion = artifact.isSnapshot();
        this.extension = artifact.getExtension();
        this.dependencies = this.parseDependencies(children);
    }

    static MavenArtifactInfo fromDependencyNode(DependencyNode dependencyNode) {
        Artifact artifact = dependencyNode.getDependency().getArtifact();
        List children = dependencyNode.getChildren();
        return new MavenArtifactInfoImpl(artifact, children);
    }

    protected MavenArtifactInfo[] parseDependencies(List<DependencyNode> children) {
        MavenArtifactInfo[] dependecies = new MavenArtifactInfo[children.size()];
        int i = 0;
        for (DependencyNode child : children) {
            dependecies[i++] = MavenArtifactInfoImpl.fromDependencyNode(child);
        }
        return dependecies;
    }

    public MavenCoordinate getCoordinate() {
        return this.mavenCoordinate;
    }

    public String getResolvedVersion() {
        return this.resolvedVersion;
    }

    public boolean isSnapshotVersion() {
        return this.snapshotVersion;
    }

    public String getExtension() {
        return this.extension;
    }

    public MavenArtifactInfo[] getDependencies() {
        return this.dependencies;
    }

    public String toString() {
        return "MavenArtifactInfoImpl [mavenCoordinate=" + this.mavenCoordinate + ", resolvedVersion=" + this.resolvedVersion + ", snapshotVersion=" + this.snapshotVersion + ", extension=" + this.extension + ", dependencies=" + Arrays.toString(this.dependencies) + "]";
    }
}

