/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.apache.maven.repository.internal;

import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import shaded.org.apache.maven.artifact.repository.metadata.Metadata;
import shaded.org.apache.maven.artifact.repository.metadata.Plugin;
import shaded.org.apache.maven.repository.internal.MavenMetadata;
import shaded.org.eclipse.aether.metadata.Metadata;

final class PluginsMetadata
extends MavenMetadata {
    private final PluginInfo pluginInfo;

    PluginsMetadata(PluginInfo pluginInfo, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), null, timestamp);
        this.pluginInfo = pluginInfo;
    }

    PluginsMetadata(PluginInfo pluginInfo, File file, Date timestamp) {
        super(PluginsMetadata.createRepositoryMetadata(pluginInfo), file, timestamp);
        this.pluginInfo = pluginInfo;
    }

    private static Metadata createRepositoryMetadata(PluginInfo pluginInfo) {
        Metadata result = new Metadata();
        Plugin plugin = new Plugin();
        plugin.setPrefix(pluginInfo.goalPrefix);
        plugin.setArtifactId(pluginInfo.artifactId);
        plugin.setName(pluginInfo.name);
        result.getPlugins().add(plugin);
        return result;
    }

    @Override
    protected void merge(Metadata recessive) {
        List<Plugin> recessivePlugins = recessive.getPlugins();
        List<Plugin> plugins = this.metadata.getPlugins();
        if (!plugins.isEmpty()) {
            LinkedHashMap mergedPlugins = new LinkedHashMap();
            recessivePlugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            plugins.forEach(p -> mergedPlugins.put(p.getPrefix(), p));
            this.metadata.setPlugins(new ArrayList<Plugin>(mergedPlugins.values()));
        }
    }

    @Override
    public MavenMetadata setFile(File file) {
        return new PluginsMetadata(this.pluginInfo, file, this.timestamp);
    }

    @Override
    public String getGroupId() {
        return this.pluginInfo.groupId;
    }

    @Override
    public String getArtifactId() {
        return "";
    }

    @Override
    public String getVersion() {
        return "";
    }

    @Override
    public Metadata.Nature getNature() {
        return Metadata.Nature.RELEASE_OR_SNAPSHOT;
    }

    static final class PluginInfo {
        final String groupId;
        private final String artifactId;
        private final String goalPrefix;
        private final String name;

        PluginInfo(String groupId, String artifactId, String goalPrefix, String name) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.goalPrefix = goalPrefix;
            this.name = name;
        }
    }
}

