/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.codehaus.plexus.logging;

import shaded.org.codehaus.plexus.logging.Logger;

public abstract class AbstractLogger
implements Logger {
    private final String name;
    private int threshold;

    public AbstractLogger(int threshold, String name) {
        this.name = name;
        if (threshold < 0 || 5 < threshold) {
            throw new IllegalArgumentException("Threshold " + threshold + " is not valid");
        }
        this.threshold = threshold;
    }

    @Override
    public final void debug(String message) {
        this.debug(message, null);
    }

    @Override
    public boolean isDebugEnabled() {
        return this.threshold <= 0;
    }

    @Override
    public final void info(String message) {
        this.info(message, null);
    }

    @Override
    public boolean isInfoEnabled() {
        return this.threshold <= 1;
    }

    @Override
    public final void warn(String message) {
        this.warn(message, null);
    }

    @Override
    public boolean isWarnEnabled() {
        return this.threshold <= 2;
    }

    @Override
    public final void error(String message) {
        this.error(message, null);
    }

    @Override
    public boolean isErrorEnabled() {
        return this.threshold <= 3;
    }

    @Override
    public final void fatalError(String message) {
        this.fatalError(message, null);
    }

    @Override
    public boolean isFatalErrorEnabled() {
        return this.threshold <= 4;
    }

    @Override
    public final int getThreshold() {
        return this.threshold;
    }

    @Override
    public final void setThreshold(int threshold) {
        this.threshold = threshold;
    }

    @Override
    public final String getName() {
        return this.name;
    }
}

