/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.named.support;

import java.util.ArrayDeque;
import java.util.Collections;
import java.util.Deque;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import shaded.org.eclipse.aether.named.NamedLock;
import shaded.org.eclipse.aether.named.support.NamedLockFactorySupport;
import shaded.org.slf4j.Logger;
import shaded.org.slf4j.LoggerFactory;

public abstract class NamedLockSupport
implements NamedLock {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final String name;
    private final NamedLockFactorySupport factory;
    private final ConcurrentHashMap<Thread, Deque<String>> diagnosticState;

    public NamedLockSupport(String name, NamedLockFactorySupport factory) {
        this.name = name;
        this.factory = factory;
        this.diagnosticState = factory.isDiagnosticEnabled() ? new ConcurrentHashMap() : null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean lockShared(long time, TimeUnit unit) throws InterruptedException {
        if (this.diagnosticState != null) {
            this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque()).push("shared");
        }
        return this.doLockShared(time, unit);
    }

    protected abstract boolean doLockShared(long var1, TimeUnit var3) throws InterruptedException;

    @Override
    public boolean lockExclusively(long time, TimeUnit unit) throws InterruptedException {
        if (this.diagnosticState != null) {
            this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque()).push("exclusive");
        }
        return this.doLockExclusively(time, unit);
    }

    protected abstract boolean doLockExclusively(long var1, TimeUnit var3) throws InterruptedException;

    @Override
    public void unlock() {
        this.doUnlock();
        if (this.diagnosticState != null) {
            this.diagnosticState.computeIfAbsent(Thread.currentThread(), k -> new ArrayDeque()).pop();
        }
    }

    protected abstract void doUnlock();

    @Override
    public void close() {
        this.doClose();
    }

    protected void doClose() {
        this.factory.closeLock(this.name);
    }

    public Map<Thread, Deque<String>> diagnosticState() {
        if (this.diagnosticState != null) {
            return this.diagnosticState;
        }
        return Collections.emptyMap();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{name='" + this.name + '\'' + '}';
    }
}

