/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.util;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;

public final class FileUtils {
    private FileUtils() {
    }

    public static TempFile newTempFile() throws IOException {
        final Path tempFile = Files.createTempFile("resolver", "tmp", new FileAttribute[0]);
        return new TempFile(){

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void close() throws IOException {
                Files.deleteIfExists(tempFile);
            }
        };
    }

    public static CollocatedTempFile newTempFile(final Path file) throws IOException {
        Path parent = Objects.requireNonNull(file.getParent(), "file must have parent");
        Files.createDirectories(parent, new FileAttribute[0]);
        final Path tempFile = parent.resolve(file.getFileName() + "." + Long.toUnsignedString(ThreadLocalRandom.current().nextLong()) + ".tmp");
        return new CollocatedTempFile(){

            @Override
            public Path getPath() {
                return tempFile;
            }

            @Override
            public void move() throws IOException {
                Files.move(tempFile, file, StandardCopyOption.ATOMIC_MOVE);
            }

            @Override
            public void close() throws IOException {
                Files.deleteIfExists(tempFile);
            }
        };
    }

    public static void writeFile(Path target, FileWriter writer) throws IOException {
        FileUtils.writeFile(target, writer, false);
    }

    public static void writeFileWithBackup(Path target, FileWriter writer) throws IOException {
        FileUtils.writeFile(target, writer, true);
    }

    private static void writeFile(Path target, FileWriter writer, boolean doBackup) throws IOException {
        Objects.requireNonNull(target, "target is null");
        Objects.requireNonNull(writer, "writer is null");
        Path parent = Objects.requireNonNull(target.getParent(), "target must have parent");
        try (CollocatedTempFile tempFile = FileUtils.newTempFile(target);){
            writer.write(tempFile.getPath());
            if (doBackup && Files.isRegularFile(target, new LinkOption[0])) {
                Files.copy(target, parent.resolve(target.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
            }
            tempFile.move();
        }
    }

    @FunctionalInterface
    public static interface FileWriter {
        public void write(Path var1) throws IOException;
    }

    public static interface CollocatedTempFile
    extends TempFile {
        public void move() throws IOException;
    }

    public static interface TempFile
    extends Closeable {
        public Path getPath();
    }
}

