/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.Provider;
import shaded.com.google.inject.Scopes;
import shaded.com.google.inject.binder.ScopedBindingBuilder;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.eclipse.sisu.inject.DeferredClass;
import shaded.org.eclipse.sisu.inject.Sources;
import shaded.org.eclipse.sisu.plexus.PlexusTypeListener;
import shaded.org.eclipse.sisu.plexus.Roles;
import shaded.org.eclipse.sisu.space.QualifiedTypeBinder;
import shaded.org.eclipse.sisu.space.QualifiedTypeListener;

public final class PlexusTypeBinder
implements PlexusTypeListener {
    private final Binder binder;
    private final QualifiedTypeListener qualifiedTypeBinder;

    public PlexusTypeBinder(Binder binder) {
        this.binder = binder;
        this.qualifiedTypeBinder = new QualifiedTypeBinder(binder);
    }

    @Override
    public void hear(Class<?> qualifiedType, Object source) {
        this.qualifiedTypeBinder.hear(qualifiedType, source);
    }

    @Override
    public void hear(Component component, DeferredClass<?> clazz, Object source) {
        Key<?> roleKey = Roles.componentKey(component);
        String strategy = component.instantiationStrategy();
        Class<?> role = component.role();
        Binder componentBinder = this.componentBinder(source, component.description());
        ScopedBindingBuilder sbb = role.getName().equals(clazz.getName()) ? (roleKey.getAnnotation() != null ? componentBinder.bind(roleKey).to(role) : componentBinder.bind(roleKey)) : ("load-on-start".equals(strategy) ? componentBinder.bind(roleKey).to(clazz.load()) : componentBinder.bind(roleKey).toProvider((Provider<?>)clazz.asProvider()));
        if ("load-on-start".equals(strategy)) {
            sbb.asEagerSingleton();
        } else if (!"per-lookup".equals(strategy)) {
            sbb.in(Scopes.SINGLETON);
        }
    }

    private Binder componentBinder(Object source, String description) {
        if (description != null && description.length() > 0) {
            return this.binder.withSource(Sources.describe(source, description));
        }
        return this.binder.withSource(source);
    }
}

