/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.space;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import shaded.com.google.inject.Binder;
import shaded.com.google.inject.Key;
import shaded.com.google.inject.TypeLiteral;
import shaded.com.google.inject.matcher.AbstractMatcher;
import shaded.com.google.inject.spi.InjectionListener;
import shaded.com.google.inject.spi.TypeEncounter;
import shaded.com.google.inject.spi.TypeListener;
import shaded.javax.inject.Provider;
import shaded.org.eclipse.sisu.Mediator;
import shaded.org.eclipse.sisu.inject.BeanLocator;

final class MediationListener
extends AbstractMatcher<TypeLiteral<?>>
implements TypeListener,
InjectionListener<Object> {
    private final List<Mediation<?, ?, ?>> mediation = new ArrayList();
    private final Provider<BeanLocator> locator;

    public MediationListener(Binder binder) {
        this.locator = binder.getProvider(BeanLocator.class);
    }

    public void mediate(Key key, Mediator mediator, Class watcherType) {
        this.mediation.add(new Mediation(key, mediator, watcherType));
    }

    @Override
    public boolean matches(TypeLiteral<?> type) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isAssignableFrom(type.getRawType())) continue;
            return true;
        }
        return false;
    }

    public <T> void hear(TypeLiteral<T> type, TypeEncounter<T> encounter) {
        encounter.register(this);
    }

    @Override
    public void afterInjection(Object watcher) {
        for (Mediation<?, ?, ?> m : this.mediation) {
            if (!m.watcherType.isInstance(watcher)) continue;
            this.locator.get().watch(m.watchedKey, m.mediator, watcher);
        }
    }

    private static final class Mediation<Q extends Annotation, T, W> {
        final Key<T> watchedKey;
        final Mediator<Q, T, W> mediator;
        final Class<W> watcherType;

        Mediation(Key<T> watchedKey, Mediator<Q, T, W> mediator, Class<W> watcherType) {
            this.watchedKey = watchedKey;
            this.mediator = mediator;
            this.watcherType = watcherType;
        }
    }
}

