/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.api.maven;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public enum ScopeType {
    COMPILE("compile"),
    PROVIDED("provided"),
    RUNTIME("runtime"),
    TEST("test"),
    SYSTEM("system"),
    IMPORT("import");

    private final String value;
    private static final Logger log;
    private static final Map<String, ScopeType> SCOPE_NAME_CACHE;

    private ScopeType(String value) {
        this.value = value;
    }

    public String toString() {
        return this.value;
    }

    public static ScopeType fromScopeType(String scopeName) throws IllegalArgumentException {
        if (scopeName == null || scopeName.length() == 0) {
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, "Empty scope was replaced with default {0}", ScopeType.COMPILE.value);
            }
            return COMPILE;
        }
        ScopeType scope = SCOPE_NAME_CACHE.get(scopeName);
        if (scope == null) {
            throw new IllegalArgumentException("Scope type " + scopeName + " is not supported.");
        }
        return scope;
    }

    static {
        log = Logger.getLogger(ScopeType.class.getName());
        SCOPE_NAME_CACHE = new HashMap<String, ScopeType>(){
            private static final long serialVersionUID = 1L;
            {
                for (ScopeType scope : ScopeType.values()) {
                    this.put(scope.value, scope);
                }
            }
        };
    }
}

