/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shaded.org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinateImpl;

public final class MavenCoordinates {
    private MavenCoordinates() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static MavenCoordinate createCoordinate(String canonicalForm) throws IllegalArgumentException, CoordinateParseException {
        if (canonicalForm == null || canonicalForm.length() == 0) {
            throw new IllegalArgumentException("canonical form is required");
        }
        MavenCoordinateParser parser = MavenCoordinateParser.parse(canonicalForm);
        return MavenCoordinates.createCoordinate(parser.getGroupId(), parser.getArtifactId(), parser.getVersion(), parser.getPackaging(), parser.getClassifier());
    }

    public static MavenCoordinate createCoordinate(String groupId, String artifactId, String version, PackagingType packaging, String classifier) throws IllegalArgumentException {
        if (groupId == null || groupId.length() == 0) {
            throw new IllegalArgumentException("groupId is required");
        }
        if (artifactId == null || artifactId.length() == 0) {
            throw new IllegalArgumentException("artifactId is required");
        }
        MavenCoordinateImpl coordinate = new MavenCoordinateImpl(groupId, artifactId, version, packaging, classifier);
        return coordinate;
    }

    static class MavenCoordinateParser {
        private static final Pattern DEPENDENCY_PATTERN = Pattern.compile("([^: ]+):([^: ]+)(:([^: ]*)(:([^: ]+))?)?(:([^: ]+))?");
        private static final String EMPTY_STRING = "";
        private static final int IS_POS_1 = 1;
        private static final int ID_POS_2 = 2;
        private static final int ID_POS_3 = 4;
        private static final int ID_POS_4 = 6;
        private static final int ID_POS_5 = 8;
        private String groupId;
        private String artifactId;
        private PackagingType type = PackagingType.JAR;
        private String classifier = "";
        private String version;

        private MavenCoordinateParser() {
        }

        static MavenCoordinateParser parse(String coordinates) throws CoordinateParseException {
            Matcher m = DEPENDENCY_PATTERN.matcher(coordinates);
            if (!m.matches()) {
                throw new CoordinateParseException("Bad artifact coordinates, expected format is <groupId>:<artifactId>[:<packagingType>[:<classifier>]]:(<version>|'?'), got: " + coordinates);
            }
            MavenCoordinateParser parser = new MavenCoordinateParser();
            parser.groupId = m.group(1);
            parser.artifactId = m.group(2);
            String position3 = m.group(4);
            String position4 = m.group(6);
            String position5 = m.group(8);
            int noOfColons = MavenCoordinateParser.numberOfOccurrences(coordinates, ':');
            switch (noOfColons) {
                case 2: {
                    parser.version = position3;
                    break;
                }
                case 3: {
                    parser.type = position3 == null || position3.length() == 0 ? PackagingType.JAR : MavenCoordinateParser.toPackagingType(position3);
                    parser.version = position4;
                    break;
                }
                default: {
                    parser.type = position3 == null || position3.length() == 0 ? PackagingType.JAR : MavenCoordinateParser.toPackagingType(position3);
                    parser.classifier = position4;
                    parser.version = position5;
                }
            }
            return parser;
        }

        public PackagingType getPackaging() {
            return this.type;
        }

        public String getClassifier() {
            return this.classifier;
        }

        public String getVersion() {
            return this.version;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        private static int numberOfOccurrences(CharSequence haystack, char needle) {
            int counter = 0;
            for (int i = 0; i < haystack.length(); ++i) {
                if (haystack.charAt(i) != needle) continue;
                ++counter;
            }
            return counter;
        }

        private static PackagingType toPackagingType(String type) {
            assert (type != null) : "Should not be fed a null type via internals (regardless of user input)";
            PackagingType parsedPackagingType = null;
            try {
                parsedPackagingType = PackagingType.of(type);
            }
            catch (IllegalArgumentException iae) {
                throw new CoordinateParseException(iae.getMessage());
            }
            return parsedPackagingType;
        }
    }
}

