/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven.task;

import shaded.org.jboss.shrinkwrap.resolver.api.maven.InvalidEnvironmentException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenWorkingSession;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.ConfigureSettingsFromFileTask;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.LoadPomTask;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.MavenWorkingSessionTask;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.task.SecurityActions;
import shaded.org.jboss.shrinkwrap.resolver.impl.maven.util.Validate;

public enum ConfigureSettingsFromPluginTask implements MavenWorkingSessionTask<MavenWorkingSession>
{
    INSTANCE;

    private static final String POM_FILE_KEY = "maven.execution.pom-file";
    private static final String OFFLINE_KEY = "maven.execution.offline";
    private static final String USER_SETTINGS_KEY = "maven.execution.user-settings";
    private static final String GLOBAL_SETTINGS_KEY = "maven.execution.global-settings";
    private static final String ACTIVE_PROFILES_KEY = "maven.execution.active-profiles";
    private static final String CONSTRUCTION_EXCEPTION = "Configuration from environment requires that user has following properties set, however they were not detected in runtime environment:\n\tmaven.execution.pom-file\n\tmaven.execution.offline\n\tmaven.execution.user-settings\n\tmaven.execution.global-settings\n\tmaven.execution.active-profiles\n\nYou should enable ShrinkWrap Maven Resolver Plugin to get them set for you automatically if executing from Maven via adding following to your <build> section:\n\n<plugin>\n\t<groupId>org.jboss.shrinkwrap.resolver</groupId>\n\t<artifactId>shrinkwrap-resolver-maven-plugin</artifactId>\n\t<executions>\n\t\t<execution>\n\t\t\t<goals>\n\t\t\t\t<goal>propagate-execution-context</goal>\n\t\t\t</goals>\n\t\t</execution>\n\t</executions>\n</plugin>\n";

    @Override
    public MavenWorkingSession execute(MavenWorkingSession session) {
        String pomFile = SecurityActions.getProperty(POM_FILE_KEY);
        if (Validate.isNullOrEmpty(pomFile)) {
            throw new InvalidEnvironmentException(CONSTRUCTION_EXCEPTION);
        }
        Validate.isReadable(pomFile, "POM file " + pomFile + " does not represent a readable file");
        String userSettings = SecurityActions.getProperty(USER_SETTINGS_KEY);
        if (Validate.isNullOrEmpty(userSettings)) {
            throw new InvalidEnvironmentException(CONSTRUCTION_EXCEPTION);
        }
        boolean hasSettingsXml = true;
        try {
            Validate.isReadable(userSettings, "Settings.xml file " + userSettings + " does not represent a readable file");
        }
        catch (IllegalArgumentException iae) {
            hasSettingsXml = false;
        }
        if (hasSettingsXml) {
            session = new ConfigureSettingsFromFileTask(userSettings).execute(session);
        }
        String activeProfiles = SecurityActions.getProperty(ACTIVE_PROFILES_KEY);
        String[] profiles = new String[]{};
        if (!Validate.isNullOrEmpty(activeProfiles)) {
            profiles = activeProfiles.split(",");
        }
        return LoadPomTask.loadPomFromFile(pomFile, profiles).execute(session);
    }
}

