/*
 * Decompiled with CFR 0.152.
 */
package eu.maveniverse.maven.mima.runtime.maven;

import eu.maveniverse.maven.mima.context.Context;
import eu.maveniverse.maven.mima.context.ContextOverrides;
import eu.maveniverse.maven.mima.context.HTTPProxy;
import eu.maveniverse.maven.mima.context.MavenSystemHome;
import eu.maveniverse.maven.mima.context.MavenUserHome;
import eu.maveniverse.maven.mima.context.internal.MavenSystemHomeImpl;
import eu.maveniverse.maven.mima.context.internal.MavenUserHomeImpl;
import eu.maveniverse.maven.mima.context.internal.RuntimeSupport;
import eu.maveniverse.maven.mima.runtime.maven.internal.PlexusLookup;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import shaded.javax.inject.Inject;
import shaded.javax.inject.Named;
import shaded.javax.inject.Provider;
import shaded.javax.inject.Singleton;
import shaded.org.apache.maven.execution.MavenExecutionRequest;
import shaded.org.apache.maven.execution.MavenSession;
import shaded.org.apache.maven.rtinfo.RuntimeInformation;
import shaded.org.apache.maven.settings.Proxy;
import shaded.org.codehaus.plexus.PlexusContainer;
import shaded.org.eclipse.aether.RepositorySystem;
import shaded.org.eclipse.aether.RepositorySystemSession;

@Singleton
@Named
public final class MavenRuntime
extends RuntimeSupport {
    private final RepositorySystem repositorySystem;
    private final PlexusContainer plexusContainer;
    private final Provider<MavenSession> mavenSessionProvider;

    @Inject
    public MavenRuntime(RepositorySystem repositorySystem, PlexusContainer plexusContainer, Provider<MavenSession> mavenSessionProvider, RuntimeInformation rt) {
        super("embedded-maven", MavenRuntime.discoverArtifactVersion("eu.maveniverse.maven.mima.runtime", "embedded-maven", "(unknown)"), 10, MavenRuntime.mavenVersion(rt));
        this.repositorySystem = repositorySystem;
        this.plexusContainer = plexusContainer;
        this.mavenSessionProvider = mavenSessionProvider;
    }

    private static String mavenVersion(RuntimeInformation runtimeInformation) {
        String mavenVersion = runtimeInformation.getMavenVersion();
        if (mavenVersion == null || mavenVersion.trim().isEmpty()) {
            return "(unknown)";
        }
        return mavenVersion;
    }

    @Override
    public boolean managedRepositorySystem() {
        return false;
    }

    @Override
    public Context create(ContextOverrides overrides) {
        MavenSession mavenSession = this.mavenSessionProvider.get();
        boolean projectPresent = mavenSession.getRequest().isProjectPresent();
        Path basedir = projectPresent ? mavenSession.getCurrentProject().getBasedir().toPath().toAbsolutePath() : DEFAULT_BASEDIR;
        MavenUserHome mavenUserHome = this.discoverMavenUserHome(mavenSession.getRequest());
        MavenSystemHome mavenSystemHome = this.discoverMavenSystemHome(mavenSession.getRequest());
        RepositorySystemSession session = mavenSession.getRepositorySession();
        ContextOverrides.Builder effectiveOverridesBuilder = overrides.toBuilder();
        effectiveOverridesBuilder.withUserSettings(true);
        if (projectPresent) {
            effectiveOverridesBuilder.repositories(mavenSession.getCurrentProject().getRemoteProjectRepositories());
        }
        effectiveOverridesBuilder.systemProperties(session.getSystemProperties());
        effectiveOverridesBuilder.userProperties(session.getUserProperties());
        effectiveOverridesBuilder.configProperties(session.getConfigProperties());
        ContextOverrides effective = effectiveOverridesBuilder.build();
        return this.customizeContext(this, overrides, new Context(this, effective, basedir, mavenUserHome, mavenSystemHome, this.repositorySystem, session, Collections.unmodifiableList(this.repositorySystem.newResolutionRepositories(session, effective.getRepositories())), this.toHTTPProxy(mavenSession.getSettings().getActiveProxy()), new PlexusLookup(this.plexusContainer), null), false);
    }

    private HTTPProxy toHTTPProxy(Proxy proxy) {
        if (proxy == null) {
            return null;
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        if (proxy.getUsername() != null) {
            data.put("username", proxy.getUsername());
        }
        if (proxy.getPassword() != null) {
            data.put("password", proxy.getPassword());
        }
        return new HTTPProxy(proxy.getProtocol(), proxy.getHost(), proxy.getPort(), proxy.getNonProxyHosts(), data);
    }

    private MavenUserHome discoverMavenUserHome(MavenExecutionRequest executionRequest) {
        return new MavenUserHomeImpl(DEFAULT_MAVEN_USER_HOME, executionRequest.getUserSettingsFile() != null ? executionRequest.getUserSettingsFile().toPath().toAbsolutePath() : null, null, executionRequest.getUserToolchainsFile() != null ? executionRequest.getUserToolchainsFile().toPath().toAbsolutePath() : null, executionRequest.getLocalRepositoryPath().toPath().toAbsolutePath());
    }

    private MavenSystemHome discoverMavenSystemHome(MavenExecutionRequest executionRequest) {
        return new MavenSystemHomeImpl(Paths.get(System.getProperty("maven.home"), new String[0]).toAbsolutePath(), executionRequest.getGlobalSettingsFile() != null ? executionRequest.getGlobalSettingsFile().toPath().toAbsolutePath() : null, executionRequest.getGlobalToolchainsFile() != null ? executionRequest.getGlobalToolchainsFile().toPath().toAbsolutePath() : null);
    }
}

