/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.codehaus.plexus.component.configurator.converters.basic;

import shaded.org.codehaus.plexus.component.configurator.ComponentConfigurationException;
import shaded.org.codehaus.plexus.component.configurator.ConfigurationListener;
import shaded.org.codehaus.plexus.component.configurator.converters.AbstractConfigurationConverter;
import shaded.org.codehaus.plexus.component.configurator.converters.lookup.ConverterLookup;
import shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import shaded.org.codehaus.plexus.component.configurator.expression.ExpressionEvaluator;
import shaded.org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import shaded.org.codehaus.plexus.configuration.PlexusConfiguration;

public abstract class AbstractBasicConverter
extends AbstractConfigurationConverter {
    @Override
    public Object fromConfiguration(ConverterLookup lookup, PlexusConfiguration configuration, Class<?> type, Class<?> enclosingType, ClassLoader loader, ExpressionEvaluator evaluator, ConfigurationListener listener) throws ComponentConfigurationException {
        if (configuration.getChildCount() > 0) {
            throw new ComponentConfigurationException("Basic element '" + configuration.getName() + "' must not contain child elements");
        }
        Object result = this.fromExpression(configuration, evaluator, type);
        if (result instanceof String) {
            try {
                result = this.fromString((String)result, type);
            }
            catch (ComponentConfigurationException e) {
                if (null == e.getFailedConfiguration()) {
                    e.setFailedConfiguration(configuration);
                }
                throw e;
            }
        }
        return result;
    }

    protected Object fromString(String str, Class<?> type) throws ComponentConfigurationException {
        return this.fromString(str);
    }

    protected Object fromString(String str) throws ComponentConfigurationException {
        throw new UnsupportedOperationException("The class " + this.getClass().getName() + " must implement one of the fromString(...) methods, but it doesn't");
    }

    @Override
    protected Object fromExpression(PlexusConfiguration configuration, ExpressionEvaluator evaluator, Class<?> type) throws ComponentConfigurationException {
        String value = configuration.getValue();
        try {
            Object result = null;
            if (null != value && value.length() > 0) {
                result = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type) : evaluator.evaluate(value);
            }
            if (null == result && null != (value = configuration.getAttribute("default-value")) && value.length() > 0) {
                result = evaluator instanceof TypeAwareExpressionEvaluator ? ((TypeAwareExpressionEvaluator)evaluator).evaluate(value, type) : evaluator.evaluate(value);
            }
            return result;
        }
        catch (ExpressionEvaluationException e) {
            String reason = String.format("Cannot evaluate expression '%s' for configuration entry '%s'", value, configuration.getName());
            throw new ComponentConfigurationException(configuration, reason, e);
        }
    }
}

