/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.aether.internal.impl.resolution;

import java.util.List;
import java.util.Objects;
import shaded.org.eclipse.aether.RepositorySystemSession;
import shaded.org.eclipse.aether.resolution.ArtifactResult;
import shaded.org.eclipse.aether.spi.resolution.ArtifactResolverPostProcessor;
import shaded.org.eclipse.aether.util.ConfigUtils;

public abstract class ArtifactResolverPostProcessorSupport
implements ArtifactResolverPostProcessor {
    private static final String CONFIG_PROP_PREFIX = "aether.artifactResolver.postProcessor.";
    private final String name;

    protected ArtifactResolverPostProcessorSupport(String name) {
        this.name = Objects.requireNonNull(name);
    }

    @Override
    public void postProcess(RepositorySystemSession session, List<ArtifactResult> artifactResults) {
        if (this.isEnabled(session)) {
            this.doPostProcess(session, artifactResults);
        }
    }

    protected abstract void doPostProcess(RepositorySystemSession var1, List<ArtifactResult> var2);

    protected String configPropKey(String name) {
        Objects.requireNonNull(name);
        return CONFIG_PROP_PREFIX + this.name + "." + name;
    }

    protected boolean isEnabled(RepositorySystemSession session) {
        return ConfigUtils.getBoolean(session, false, CONFIG_PROP_PREFIX + this.name);
    }
}

