/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.eclipse.sisu.plexus;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import shaded.org.codehaus.plexus.component.annotations.Component;
import shaded.org.codehaus.plexus.component.annotations.Configuration;
import shaded.org.codehaus.plexus.component.annotations.Requirement;
import shaded.org.codehaus.plexus.util.IOUtil;
import shaded.org.codehaus.plexus.util.InterpolationFilterReader;
import shaded.org.codehaus.plexus.util.ReaderFactory;
import shaded.org.codehaus.plexus.util.xml.XmlStreamReader;
import shaded.org.codehaus.plexus.util.xml.pull.MXParser;
import shaded.org.codehaus.plexus.util.xml.pull.XmlPullParser;
import shaded.org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import shaded.org.eclipse.sisu.inject.DeferredClass;
import shaded.org.eclipse.sisu.inject.Logs;
import shaded.org.eclipse.sisu.plexus.ConfigurationImpl;
import shaded.org.eclipse.sisu.plexus.Hints;
import shaded.org.eclipse.sisu.plexus.PlexusBeanMetadata;
import shaded.org.eclipse.sisu.plexus.PlexusTypeRegistry;
import shaded.org.eclipse.sisu.plexus.PlexusXmlMetadata;
import shaded.org.eclipse.sisu.plexus.RequirementImpl;
import shaded.org.eclipse.sisu.plexus.Roles;
import shaded.org.eclipse.sisu.space.ClassSpace;
import shaded.org.eclipse.sisu.space.Streams;

final class PlexusXmlScanner {
    private final Map<?, ?> variables;
    private final URL plexusXml;
    private final Map<String, PlexusBeanMetadata> metadata;

    PlexusXmlScanner(Map<?, ?> variables, URL plexusXml, Map<String, PlexusBeanMetadata> metadata) {
        this.variables = variables;
        this.plexusXml = plexusXml;
        this.metadata = metadata;
    }

    Map<Component, DeferredClass<?>> scan(ClassSpace space, boolean root) {
        PlexusTypeRegistry registry = new PlexusTypeRegistry(space);
        if (null != this.plexusXml) {
            this.parsePlexusXml(this.plexusXml, registry);
        }
        Enumeration<URL> e = root ? space.getResources("META-INF/plexus/components.xml") : space.findEntries("META-INF/plexus", "components.xml", false);
        while (e.hasMoreElements()) {
            this.parseComponentsXml(e.nextElement(), registry);
        }
        return registry.getComponents();
    }

    private static Reader filteredXmlReader(InputStream in, Map variables) throws IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader(in);
        if (null != variables) {
            return new InterpolationFilterReader(reader, variables);
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parsePlexusXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                while (parser.nextTag() == 2) {
                    String name = parser.getName();
                    if ("load-on-start".equals(name)) {
                        while (parser.nextTag() == 2) {
                            PlexusXmlScanner.parseLoadOnStart(parser, registry);
                        }
                        continue;
                    }
                    if ("components".equals(name)) {
                        while (parser.nextTag() == 2) {
                            this.parseComponent(parser, registry);
                        }
                        continue;
                    }
                    parser.skipSubTree();
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseComponentsXml(URL url, PlexusTypeRegistry registry) {
        try {
            InputStream in = Streams.open(url);
            try {
                MXParser parser = new MXParser();
                parser.setInput(PlexusXmlScanner.filteredXmlReader(in, this.variables));
                parser.nextTag();
                parser.require(2, null, null);
                parser.nextTag();
                parser.require(2, null, "components");
                while (parser.nextTag() == 2) {
                    this.parseComponent(parser, registry);
                }
            }
            finally {
                IOUtil.close(in);
            }
        }
        catch (Exception e) {
            Logs.trace("Problem parsing: {}", url, e);
        }
    }

    private static void parseLoadOnStart(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        if ("component".equals(parser.getName())) {
            String role = null;
            String hint = "";
            while (parser.nextTag() == 2) {
                if ("role".equals(parser.getName())) {
                    role = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                if ("role-hint".equals(parser.getName())) {
                    hint = PlexusXmlScanner.TEXT(parser);
                    continue;
                }
                parser.skipSubTree();
            }
            if (null == role) {
                throw new XmlPullParserException("Missing <role> element.", parser, null);
            }
            registry.loadOnStart(role, hint);
        } else {
            parser.skipSubTree();
        }
    }

    private void parseComponent(MXParser parser, PlexusTypeRegistry registry) throws XmlPullParserException, IOException {
        String role = null;
        String hint = "";
        String instantiationStrategy = "singleton";
        String description = "";
        String implementation = null;
        HashMap<String, Requirement> requirementMap = new HashMap<String, Requirement>();
        HashMap<String, Configuration> configurationMap = new HashMap<String, Configuration>();
        ClassSpace space = registry.getSpace();
        parser.require(2, null, "component");
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if ("requirements".equals(name)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseRequirement(parser, space, requirementMap);
                }
                continue;
            }
            if ("configuration".equals(name)) {
                while (parser.nextTag() == 2) {
                    PlexusXmlScanner.parseConfiguration(parser, configurationMap);
                }
                continue;
            }
            if ("role".equals(name)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name)) {
                hint = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("instantiation-strategy".equals(name)) {
                instantiationStrategy = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("description".equals(name)) {
                description = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("implementation".equals(name)) {
                implementation = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            parser.skipSubTree();
        }
        if (null == implementation) {
            throw new XmlPullParserException("Missing <implementation> element.", parser, null);
        }
        if (null == role) {
            role = implementation;
        }
        if (null != (implementation = registry.addComponent(role, hint, instantiationStrategy, description, implementation))) {
            this.updatePlexusBeanMetadata(implementation, configurationMap, requirementMap);
        }
    }

    private void updatePlexusBeanMetadata(String implementation, Map<String, Configuration> configurationMap, Map<String, Requirement> requirementMap) {
        if (!(null == this.metadata || configurationMap.isEmpty() && requirementMap.isEmpty())) {
            PlexusXmlMetadata beanMetadata = (PlexusXmlMetadata)this.metadata.get(implementation);
            if (beanMetadata != null) {
                beanMetadata.merge(configurationMap, requirementMap);
            } else {
                this.metadata.put(implementation, new PlexusXmlMetadata(configurationMap, requirementMap));
            }
        }
    }

    private static void parseRequirement(MXParser parser, ClassSpace space, Map<String, Requirement> requirementMap) throws XmlPullParserException, IOException {
        String role = null;
        ArrayList<String> hintList = new ArrayList<String>();
        String fieldName = null;
        boolean optional = false;
        parser.require(2, null, "requirement");
        while (parser.nextTag() == 2) {
            String name = parser.getName();
            if ("role".equals(name)) {
                role = PlexusXmlScanner.TEXT(parser).intern();
                continue;
            }
            if ("role-hint".equals(name)) {
                hintList.add(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            if ("role-hints".equals(name)) {
                while (parser.nextTag() == 2) {
                    hintList.add(PlexusXmlScanner.TEXT(parser));
                }
                continue;
            }
            if ("field-name".equals(name)) {
                fieldName = PlexusXmlScanner.TEXT(parser);
                continue;
            }
            if ("optional".equals(name)) {
                optional = Boolean.parseBoolean(PlexusXmlScanner.TEXT(parser));
                continue;
            }
            parser.skipSubTree();
        }
        if (null == role) {
            throw new XmlPullParserException("Missing <role> element.", parser, null);
        }
        if (null == fieldName) {
            fieldName = role;
        }
        requirementMap.put(fieldName, new RequirementImpl(space.deferLoadClass(role), optional, Hints.canonicalHints(hintList)));
    }

    private static void parseConfiguration(MXParser parser, Map<String, Configuration> configurationMap) throws XmlPullParserException, IOException {
        String name = parser.getName();
        String fieldName = Roles.camelizeName(name);
        StringBuilder buf = new StringBuilder();
        String header = parser.getText().trim();
        int depth = parser.getDepth();
        while (parser.next() != 3 || parser.getDepth() > depth) {
            buf.append(parser.getText().trim());
        }
        if (buf.indexOf("<") == 0 || header.indexOf(61) > 0) {
            buf.insert(0, header);
            if (!header.endsWith("/>")) {
                buf.append("</" + name + '>');
            }
        }
        configurationMap.put(fieldName, new ConfigurationImpl(fieldName, buf.toString()));
    }

    private static String TEXT(XmlPullParser parser) throws XmlPullParserException, IOException {
        return parser.nextText().trim();
    }
}

