/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate;

import java.lang.reflect.Constructor;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import shaded.org.jboss.shrinkwrap.resolver.api.CoordinateParseException;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinate;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenCoordinates;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusionImpl;

public final class MavenDependencies {
    private static final String NAME_IMPL_CLASS = "shaded.org.jboss.shrinkwrap.resolver.impl.maven.coordinate.MavenDependencyImpl";
    private static final Constructor<MavenDependency> ctor;

    private MavenDependencies() {
        throw new UnsupportedOperationException("No instances permitted");
    }

    public static MavenDependency createDependency(String canonicalForm, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) throws IllegalArgumentException, CoordinateParseException {
        if (canonicalForm == null || canonicalForm.isEmpty()) {
            throw new IllegalArgumentException("canonical form is required");
        }
        MavenCoordinate delegate = MavenCoordinates.createCoordinate(canonicalForm);
        return MavenDependencies.createDependency(delegate, scope, optional, exclusions);
    }

    public static MavenDependency createDependency(MavenCoordinate coordinate, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) throws IllegalArgumentException, CoordinateParseException {
        if (coordinate == null) {
            throw new IllegalArgumentException("coordinate form is required");
        }
        MavenDependency dep = MavenDependencies.newInstance(coordinate, scope, optional, exclusions);
        return dep;
    }

    private static MavenDependency newInstance(MavenCoordinate coordinate, ScopeType scope, boolean optional, MavenDependencyExclusion ... exclusions) {
        assert (coordinate != null) : "coordinate must be specified";
        assert (exclusions != null) : "exclusions must be specified";
        try {
            return ctor.newInstance(new Object[]{coordinate, scope, optional, exclusions});
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create new " + MavenDependency.class.getSimpleName() + "instance", e);
        }
    }

    public static MavenDependencyExclusion createExclusion(String canonicalForm) throws IllegalArgumentException, CoordinateParseException {
        String artifactId;
        String groupId;
        if (canonicalForm == null || canonicalForm.isEmpty()) {
            throw new IllegalArgumentException("canonical form is required");
        }
        StringTokenizer tokenizer = new StringTokenizer(canonicalForm, String.valueOf(':'));
        try {
            groupId = tokenizer.nextToken();
            artifactId = tokenizer.nextToken();
        }
        catch (NoSuchElementException nsee) {
            throw new CoordinateParseException("Canonical form must be \"groupId:artifactId\"; got: " + canonicalForm);
        }
        if (tokenizer.hasMoreTokens()) {
            throw new CoordinateParseException("Canonical form must be \"groupId:artifactId\"; got: " + canonicalForm);
        }
        MavenDependencyExclusion exclusion = MavenDependencies.createExclusion(groupId, artifactId);
        return exclusion;
    }

    public static MavenDependencyExclusion createExclusion(String groupId, String artifactId) throws IllegalArgumentException {
        if (groupId == null || groupId.isEmpty()) {
            throw new IllegalArgumentException("groupId must be specified");
        }
        if (artifactId == null || artifactId.isEmpty()) {
            throw new IllegalArgumentException("groupId must be specified");
        }
        MavenDependencyExclusionImpl exclusion = new MavenDependencyExclusionImpl(groupId, artifactId);
        return exclusion;
    }

    static {
        try {
            Class<?> clazz = MavenDependencies.class.getClassLoader().loadClass(NAME_IMPL_CLASS);
            ctor = clazz.getConstructor(MavenCoordinate.class, ScopeType.class, Boolean.TYPE, MavenDependencyExclusion[].class);
        }
        catch (Exception e) {
            throw new RuntimeException("Could not obtain constructor for " + MavenDependency.class.getSimpleName(), e);
        }
    }
}

