/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.impl.maven;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Logger;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.MavenResolvedArtifact;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.PackagingType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.ScopeType;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencies;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependency;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.coordinate.MavenDependencyExclusion;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy.MavenResolutionStrategy;
import shaded.org.jboss.shrinkwrap.resolver.api.maven.strategy.NonTransitiveStrategy;

class PostResolutionFilter {
    private static final Logger log = Logger.getLogger(PostResolutionFilter.class.getName());

    PostResolutionFilter() {
    }

    static Collection<MavenResolvedArtifact> filter(Collection<MavenResolvedArtifact> artifactResults, List<MavenDependency> depsForResolution, MavenResolutionStrategy strategy) {
        ArrayList<MavenResolvedArtifact> filteredArtifacts = new ArrayList<MavenResolvedArtifact>();
        for (MavenResolvedArtifact artifact : artifactResults) {
            MavenDependency dependency = MavenDependencies.createDependency(artifact.getCoordinate(), ScopeType.COMPILE, false, new MavenDependencyExclusion[0]);
            if (PackagingType.POM.equals(dependency.getPackaging())) {
                log.finer("Filtering out POM dependency resolution: " + dependency + "; its transitive dependencies will be included");
                if (!strategy.getClass().equals(NonTransitiveStrategy.class) || !PostResolutionFilter.checkForPomInDependencies(dependency, depsForResolution)) continue;
                filteredArtifacts.add(artifact);
                continue;
            }
            filteredArtifacts.add(artifact);
        }
        return Collections.unmodifiableCollection(filteredArtifacts);
    }

    private static boolean checkForPomInDependencies(MavenDependency coordinate, List<MavenDependency> dependenciesForResolution) {
        for (MavenDependency dependency : dependenciesForResolution) {
            if (!dependency.equals(coordinate)) continue;
            return true;
        }
        return false;
    }
}

