/*
 * Decompiled with CFR 0.152.
 */
package shaded.org.jboss.shrinkwrap.resolver.spi.format;

import java.util.Collection;
import shaded.org.jboss.shrinkwrap.resolver.api.ResolvedArtifact;
import shaded.org.jboss.shrinkwrap.resolver.spi.format.FormatProcessor;
import shaded.org.jboss.shrinkwrap.resolver.spi.loader.ServiceRegistry;

public final class FormatProcessors {
    public static <RESOLVEDTYPE extends ResolvedArtifact<RESOLVEDTYPE>, RETURNTYPE> FormatProcessor<? super RESOLVEDTYPE, RETURNTYPE> find(Class<RESOLVEDTYPE> resolvedTypeClass, Class<RETURNTYPE> returnTypeClass) {
        ServiceRegistry registry = ServiceRegistry.getInstance();
        Collection<FormatProcessor> processors = registry.all(FormatProcessor.class);
        StringBuilder unsupportedFormatMessage = new StringBuilder("No format processor for ").append(returnTypeClass.getName()).append(" was found. Supported processors are: ");
        for (FormatProcessor processor : processors) {
            if (processor.handles(resolvedTypeClass) && processor.returns(returnTypeClass)) {
                return processor;
            }
            unsupportedFormatMessage.append(processor.getClass()).append(", ");
        }
        if (unsupportedFormatMessage.indexOf(", ") != -1) {
            unsupportedFormatMessage.delete(unsupportedFormatMessage.length() - 2, unsupportedFormatMessage.length());
        }
        throw new UnsupportedOperationException(unsupportedFormatMessage.toString());
    }
}

