/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractQueue;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import jdk.internal.access.SharedSecrets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Collections {
    private static final int BINARYSEARCH_THRESHOLD = 5000;
    private static final int REVERSE_THRESHOLD = 18;
    private static final int SHUFFLE_THRESHOLD = 5;
    private static final int FILL_THRESHOLD = 25;
    private static final int ROTATE_THRESHOLD = 100;
    private static final int COPY_THRESHOLD = 10;
    private static final int REPLACEALL_THRESHOLD = 11;
    private static final int INDEXOFSUBLIST_THRESHOLD = 35;
    private static Random r;
    public static final Set EMPTY_SET;
    public static final List EMPTY_LIST;
    public static final Map EMPTY_MAP;
    private static final Comparator REVERSE_ORDER;

    private Collections() {
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set((Comparable)objectArray[i]);
        }
    }

    public static <T> void sort(List<T> list, Comparator<? super T> comparator) {
        Object[] objectArray = list.toArray();
        Arrays.sort(objectArray, comparator);
        ListIterator<T> listIterator = list.listIterator();
        for (int i = 0; i < objectArray.length; ++i) {
            listIterator.next();
            listIterator.set(objectArray[i]);
        }
    }

    public static <T> int binarySearch(List<? extends Comparable<? super T>> list, T t) {
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t);
        }
        return Collections.iteratorBinarySearch(list, t);
    }

    private static <T> int indexedBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = list.get(n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends Comparable<? super T>> list, T t) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends Comparable<? super T>> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            Comparable<T> comparable = Collections.get(listIterator, n3);
            int n4 = comparable.compareTo(t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> T get(ListIterator<? extends T> listIterator, int n) {
        T t = null;
        int n2 = listIterator.nextIndex();
        if (n2 <= n) {
            do {
                t = listIterator.next();
            } while (n2++ < n);
        } else {
            do {
                t = listIterator.previous();
            } while (--n2 > n);
        }
        return t;
    }

    public static <T> int binarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.binarySearch(list, t);
        }
        if (list instanceof RandomAccess || list.size() < 5000) {
            return Collections.indexedBinarySearch(list, t, comparator);
        }
        return Collections.iteratorBinarySearch(list, t, comparator);
    }

    private static <T> int indexedBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = list.get(n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    private static <T> int iteratorBinarySearch(List<? extends T> list, T t, Comparator<? super T> comparator) {
        int n = 0;
        int n2 = list.size() - 1;
        ListIterator<? extends T> listIterator = list.listIterator();
        while (n <= n2) {
            int n3 = n + n2 >>> 1;
            T t2 = Collections.get(listIterator, n3);
            int n4 = comparator.compare(t2, t);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        return -(n + 1);
    }

    public static void reverse(List<?> list) {
        int n = list.size();
        if (n < 18 || list instanceof RandomAccess) {
            int n2 = 0;
            int n3 = n >> 1;
            int n4 = n - 1;
            while (n2 < n3) {
                Collections.swap(list, n2, n4);
                ++n2;
                --n4;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            ListIterator<?> listIterator2 = list.listIterator(n);
            int n5 = list.size() >> 1;
            for (int i = 0; i < n5; ++i) {
                Object obj = listIterator.next();
                listIterator.set(listIterator2.previous());
                listIterator2.set(obj);
            }
        }
    }

    public static void shuffle(List<?> list) {
        if (r == null) {
            r = new Random();
        }
        Collections.shuffle(list, r);
    }

    public static void shuffle(List<?> list, Random random) {
        int n = list.size();
        if (n < 5 || list instanceof RandomAccess) {
            for (int i = n; i > 1; --i) {
                Collections.swap(list, i - 1, random.nextInt(i));
            }
        } else {
            Object[] objectArray = list.toArray();
            for (int i = n; i > 1; --i) {
                Collections.swap(objectArray, i - 1, random.nextInt(i));
            }
            ListIterator<?> listIterator = list.listIterator();
            for (int i = 0; i < objectArray.length; ++i) {
                listIterator.next();
                listIterator.set(objectArray[i]);
            }
        }
    }

    public static void swap(List<?> list, int n, int n2) {
        List<?> list2 = list;
        list2.set(n, list2.set(n2, list2.get(n)));
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T> void fill(List<? super T> list, T t) {
        int n = list.size();
        if (n < 25 || list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, t);
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(t);
            }
        }
    }

    public static <T> void copy(List<? super T> list, List<? extends T> list2) {
        int n = list2.size();
        if (n > list.size()) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        if (n < 10 || list2 instanceof RandomAccess && list instanceof RandomAccess) {
            for (int i = 0; i < n; ++i) {
                list.set(i, list2.get(i));
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            ListIterator<T> listIterator2 = list2.listIterator();
            for (int i = 0; i < n; ++i) {
                listIterator.next();
                listIterator.set(listIterator2.next());
            }
        }
    }

    public static <T> T min(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T min(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.min(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) >= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection) {
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (((Comparable)t2).compareTo(t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static <T> T max(Collection<? extends T> collection, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Collections.max(collection);
        }
        Iterator<T> iterator = collection.iterator();
        T t = iterator.next();
        while (iterator.hasNext()) {
            T t2 = iterator.next();
            if (comparator.compare(t2, t) <= 0) continue;
            t = t2;
        }
        return t;
    }

    public static void rotate(List<?> list, int n) {
        if (list instanceof RandomAccess || list.size() < 100) {
            Collections.rotate1(list, n);
        } else {
            Collections.rotate2(list, n);
        }
    }

    private static <T> void rotate1(List<T> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        if ((n %= n2) < 0) {
            n += n2;
        }
        if (n == 0) {
            return;
        }
        int n3 = 0;
        int n4 = 0;
        while (n4 != n2) {
            T t = list.get(n3);
            int n5 = n3;
            do {
                if ((n5 += n) >= n2) {
                    n5 -= n2;
                }
                t = list.set(n5, t);
                ++n4;
            } while (n5 != n3);
            ++n3;
        }
    }

    private static void rotate2(List<?> list, int n) {
        int n2 = list.size();
        if (n2 == 0) {
            return;
        }
        int n3 = -n % n2;
        if (n3 < 0) {
            n3 += n2;
        }
        if (n3 == 0) {
            return;
        }
        Collections.reverse(list.subList(0, n3));
        Collections.reverse(list.subList(n3, n2));
        Collections.reverse(list);
    }

    public static <T> boolean replaceAll(List<T> list, T t, T t2) {
        boolean bl = false;
        int n = list.size();
        if (n < 11 || list instanceof RandomAccess) {
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (list.get(i) != null) continue;
                    list.set(i, t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(list.get(i))) continue;
                    list.set(i, t2);
                    bl = true;
                }
            }
        } else {
            ListIterator<T> listIterator = list.listIterator();
            if (t == null) {
                for (int i = 0; i < n; ++i) {
                    if (listIterator.next() != null) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            } else {
                for (int i = 0; i < n; ++i) {
                    if (!t.equals(listIterator.next())) continue;
                    listIterator.set(t2);
                    bl = true;
                }
            }
        }
        return bl;
    }

    public static int indexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess && list2 instanceof RandomAccess) {
            block0: for (int i = 0; i <= n3; ++i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            ListIterator<?> listIterator = list.listIterator();
            block2: for (int i = 0; i <= n3; ++i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    for (int k = 0; k < j; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static int lastIndexOfSubList(List<?> list, List<?> list2) {
        int n = list.size();
        int n2 = list2.size();
        int n3 = n - n2;
        if (n < 35 || list instanceof RandomAccess) {
            block0: for (int i = n3; i >= 0; --i) {
                int n4 = 0;
                int n5 = i;
                while (n4 < n2) {
                    if (!Collections.eq(list2.get(n4), list.get(n5))) continue block0;
                    ++n4;
                    ++n5;
                }
                return i;
            }
        } else {
            if (n3 < 0) {
                return -1;
            }
            ListIterator<?> listIterator = list.listIterator(n3);
            block2: for (int i = n3; i >= 0; --i) {
                ListIterator<?> listIterator2 = list2.listIterator();
                for (int j = 0; j < n2; ++j) {
                    if (Collections.eq(listIterator2.next(), listIterator.next())) continue;
                    if (i == 0) continue block2;
                    for (int k = 0; k <= j + 1; ++k) {
                        listIterator.previous();
                    }
                    continue block2;
                }
                return i;
            }
        }
        return -1;
    }

    public static <T> Collection<T> unmodifiableCollection(Collection<? extends T> collection) {
        return new UnmodifiableCollection<T>(collection);
    }

    public static <T> Set<T> unmodifiableSet(Set<? extends T> set) {
        return new UnmodifiableSet<T>(set);
    }

    public static <T> SortedSet<T> unmodifiableSortedSet(SortedSet<T> sortedSet) {
        return new UnmodifiableSortedSet<T>(sortedSet);
    }

    public static <T> List<T> unmodifiableList(List<? extends T> list) {
        return list instanceof RandomAccess ? new UnmodifiableRandomAccessList<T>(list) : new UnmodifiableList<T>(list);
    }

    public static <K, V> Map<K, V> unmodifiableMap(Map<? extends K, ? extends V> map) {
        return new UnmodifiableMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> unmodifiableSortedMap(SortedMap<K, ? extends V> sortedMap) {
        return new UnmodifiableSortedMap<K, V>(sortedMap);
    }

    public static <T> Collection<T> synchronizedCollection(Collection<T> collection) {
        return new SynchronizedCollection<T>(collection);
    }

    static <T> Collection<T> synchronizedCollection(Collection<T> collection, Object object) {
        return new SynchronizedCollection<T>(collection, object);
    }

    public static <T> Set<T> synchronizedSet(Set<T> set) {
        return new SynchronizedSet<T>(set);
    }

    static <T> Set<T> synchronizedSet(Set<T> set, Object object) {
        return new SynchronizedSet<T>(set, object);
    }

    public static <T> SortedSet<T> synchronizedSortedSet(SortedSet<T> sortedSet) {
        return new SynchronizedSortedSet<T>(sortedSet);
    }

    public static <T> List<T> synchronizedList(List<T> list) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list) : new SynchronizedList<T>(list);
    }

    static <T> List<T> synchronizedList(List<T> list, Object object) {
        return list instanceof RandomAccess ? new SynchronizedRandomAccessList<T>(list, object) : new SynchronizedList<T>(list, object);
    }

    public static <K, V> Map<K, V> synchronizedMap(Map<K, V> map) {
        return new SynchronizedMap<K, V>(map);
    }

    public static <K, V> SortedMap<K, V> synchronizedSortedMap(SortedMap<K, V> sortedMap) {
        return new SynchronizedSortedMap<K, V>(sortedMap);
    }

    public static <E> Collection<E> checkedCollection(Collection<E> collection, Class<E> clazz) {
        return new CheckedCollection<E>(collection, clazz);
    }

    public static <E> Set<E> checkedSet(Set<E> set, Class<E> clazz) {
        return new CheckedSet<E>(set, clazz);
    }

    public static <E> SortedSet<E> checkedSortedSet(SortedSet<E> sortedSet, Class<E> clazz) {
        return new CheckedSortedSet<E>(sortedSet, clazz);
    }

    public static <E> List<E> checkedList(List<E> list, Class<E> clazz) {
        return list instanceof RandomAccess ? new CheckedRandomAccessList<E>(list, clazz) : new CheckedList<E>(list, clazz);
    }

    public static <K, V> Map<K, V> checkedMap(Map<K, V> map, Class<K> clazz, Class<V> clazz2) {
        return new CheckedMap<K, V>(map, clazz, clazz2);
    }

    public static <K, V> SortedMap<K, V> checkedSortedMap(SortedMap<K, V> sortedMap, Class<K> clazz, Class<V> clazz2) {
        return new CheckedSortedMap<K, V>(sortedMap, clazz, clazz2);
    }

    public static final <T> Set<T> emptySet() {
        return EMPTY_SET;
    }

    public static final <T> List<T> emptyList() {
        return EMPTY_LIST;
    }

    public static final <K, V> Map<K, V> emptyMap() {
        return EMPTY_MAP;
    }

    public static <T> Set<T> singleton(T t) {
        return new SingletonSet<T>(t);
    }

    public static <T> List<T> singletonList(T t) {
        return new SingletonList<T>(t);
    }

    public static <K, V> Map<K, V> singletonMap(K k, V v) {
        return new SingletonMap<K, V>(k, v);
    }

    public static <T> List<T> nCopies(int n, T t) {
        if (n < 0) {
            throw new IllegalArgumentException("List length = " + n);
        }
        return new CopiesList<T>(n, t);
    }

    public static <T> Comparator<T> reverseOrder() {
        return REVERSE_ORDER;
    }

    public static <T> Comparator<T> reverseOrder(Comparator<T> comparator) {
        if (comparator == null) {
            return Collections.reverseOrder();
        }
        return new ReverseComparator2<T>(comparator);
    }

    public static <T> Enumeration<T> enumeration(final Collection<T> collection) {
        return new Iterator<E>(collection){
            private boolean hasNext = true;

            @Override
            public boolean hasNext() {
                return this.hasNext;
            }

            @Override
            public E next() {
                if (this.hasNext) {
                    this.hasNext = false;
                    return collection;
                }
                throw new NoSuchElementException();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public void forEachRemaining(Consumer<? super E> action) {
                Objects.requireNonNull(action);
                if (this.hasNext) {
                    this.hasNext = false;
                    action.accept(collection);
                }
            }
        };
    }

    public static <T> ArrayList<T> list(Enumeration<T> enumeration) {
        ArrayList<T> arrayList = new ArrayList<T>();
        while (enumeration.hasMoreElements()) {
            arrayList.add(enumeration.nextElement());
        }
        return arrayList;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    public static int frequency(Collection<?> collection, Object object) {
        int n = 0;
        if (object == null) {
            for (Object obj : collection) {
                if (obj != null) continue;
                ++n;
            }
        } else {
            for (Object obj : collection) {
                if (!object.equals(obj)) continue;
                ++n;
            }
        }
        return n;
    }

    public static boolean disjoint(Collection<?> collection, Collection<?> collection2) {
        if (collection instanceof Set && !(collection2 instanceof Set) || collection.size() > collection2.size()) {
            Collection<?> collection3 = collection;
            collection = collection2;
            collection2 = collection3;
        }
        for (Object e : collection) {
            if (!collection2.contains(e)) continue;
            return false;
        }
        return true;
    }

    public static <T> boolean addAll(Collection<? super T> collection, T ... TArray) {
        boolean bl = false;
        for (T t : TArray) {
            bl |= collection.add(t);
        }
        return bl;
    }

    public static <E> Set<E> newSetFromMap(Map<E, Boolean> map) {
        return new SetFromMap<E>(map);
    }

    public static <T> Queue<T> asLifoQueue(Deque<T> deque) {
        return new AsLIFOQueue<T>(deque);
    }

    static /* synthetic */ boolean access$000(Object object, Object object2) {
        return Collections.eq(object, object2);
    }

    static {
        EMPTY_SET = new EmptySet(null);
        EMPTY_LIST = new EmptyList(null);
        EMPTY_MAP = new EmptyMap(null);
        REVERSE_ORDER = new ReverseComparator(null);
    }

    static class AsLIFOQueue<E>
    extends AbstractQueue<E>
    implements Queue<E>,
    Serializable {
        private static final long serialVersionUID = 1802017725587941708L;
        private final Deque<E> q;

        AsLIFOQueue(Deque<E> q) {
            this.q = q;
        }

        @Override
        public boolean add(E e) {
            this.q.addFirst(e);
            return true;
        }

        @Override
        public boolean offer(E e) {
            return this.q.offerFirst(e);
        }

        @Override
        public E poll() {
            return this.q.pollFirst();
        }

        @Override
        public E remove() {
            return this.q.removeFirst();
        }

        @Override
        public E peek() {
            return this.q.peekFirst();
        }

        @Override
        public E element() {
            return this.q.getFirst();
        }

        @Override
        public void clear() {
            this.q.clear();
        }

        @Override
        public int size() {
            return this.q.size();
        }

        @Override
        public boolean isEmpty() {
            return this.q.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.q.contains(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.q.remove(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.q.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.q.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.q.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            return this.q.toArray(f);
        }

        @Override
        public String toString() {
            return this.q.toString();
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.q.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.q.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.q.retainAll(c);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.q.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.q.removeIf(filter);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.q.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.q.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.q.parallelStream();
        }
    }

    static class CheckedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1578914078182001775L;
        final Collection<E> c;
        final Class<E> type;
        private E[] zeroLengthElementArray;

        E typeCheck(Object o) {
            if (o != null && !this.type.isInstance(o)) {
                throw new ClassCastException(this.badElementMsg(o));
            }
            return (E)o;
        }

        private String badElementMsg(Object o) {
            return "Attempt to insert " + o.getClass() + " element into collection with element type " + this.type;
        }

        CheckedCollection(Collection<E> c, Class<E> type) {
            this.c = Objects.requireNonNull(c, "c");
            this.type = Objects.requireNonNull(type, "type");
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            return this.c.toArray(f);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public boolean remove(Object o) {
            return this.c.remove(o);
        }

        @Override
        public void clear() {
            this.c.clear();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            return this.c.removeAll(coll);
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            return this.c.retainAll(coll);
        }

        @Override
        public Iterator<E> iterator() {
            final Iterator<E> it = this.c.iterator();
            return new Iterator<E>(this){

                @Override
                public boolean hasNext() {
                    return it.hasNext();
                }

                @Override
                public E next() {
                    return it.next();
                }

                @Override
                public void remove() {
                    it.remove();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    it.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            return this.c.add(this.typeCheck(e));
        }

        private E[] zeroLengthElementArray() {
            return this.zeroLengthElementArray != null ? this.zeroLengthElementArray : (this.zeroLengthElementArray = Collections.zeroLengthArray(this.type));
        }

        Collection<E> checkedCopyOf(Collection<? extends E> coll) {
            Object[] a;
            block3: {
                try {
                    E[] z = this.zeroLengthElementArray();
                    a = coll.toArray(z);
                    if (a.getClass() == z.getClass()) break block3;
                    a = Arrays.copyOf(a, a.length, z.getClass());
                }
                catch (ArrayStoreException ignore) {
                    a = (Object[])coll.toArray().clone();
                    for (E o : a) {
                        this.typeCheck(o);
                    }
                }
            }
            return Arrays.asList(a);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            return this.c.addAll(this.checkedCopyOf(coll));
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.c.removeIf(filter);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    static class CheckedList<E>
    extends CheckedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = 65247728283967356L;
        final List<E> list;

        CheckedList(List<E> list, Class<E> type) {
            super(list, type);
            this.list = list;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E remove(int index) {
            return this.list.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public E set(int index, E element) {
            return this.list.set(index, this.typeCheck(element));
        }

        @Override
        public void add(int index, E element) {
            this.list.add(index, this.typeCheck(element));
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            return this.list.addAll(index, this.checkedCopyOf(c));
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            final ListIterator<E> i = this.list.listIterator(index);
            return new ListIterator<E>(){

                @Override
                public boolean hasNext() {
                    return i.hasNext();
                }

                @Override
                public E next() {
                    return i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return i.hasPrevious();
                }

                @Override
                public E previous() {
                    return i.previous();
                }

                @Override
                public int nextIndex() {
                    return i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return i.previousIndex();
                }

                @Override
                public void remove() {
                    i.remove();
                }

                @Override
                public void set(E e) {
                    i.set(this.typeCheck(e));
                }

                @Override
                public void add(E e) {
                    i.add(this.typeCheck(e));
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new CheckedList<E>(this.list.subList(fromIndex, toIndex), this.type);
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Objects.requireNonNull(operator);
            this.list.replaceAll(e -> this.typeCheck(operator.apply(e)));
        }

        @Override
        public void sort(Comparator<? super E> c) {
            this.list.sort(c);
        }
    }

    private static class CheckedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 5742860141034234728L;
        private final Map<K, V> m;
        final Class<K> keyType;
        final Class<V> valueType;
        private transient Set<Map.Entry<K, V>> entrySet;

        private void typeCheck(Object key, Object value) {
            if (key != null && !this.keyType.isInstance(key)) {
                throw new ClassCastException(this.badKeyMsg(key));
            }
            if (value != null && !this.valueType.isInstance(value)) {
                throw new ClassCastException(this.badValueMsg(value));
            }
        }

        private BiFunction<? super K, ? super V, ? extends V> typeCheck(BiFunction<? super K, ? super V, ? extends V> func) {
            Objects.requireNonNull(func);
            return (k, v) -> {
                Object newValue = func.apply((K)k, (V)v);
                this.typeCheck(k, newValue);
                return newValue;
            };
        }

        private String badKeyMsg(Object key) {
            return "Attempt to insert " + key.getClass() + " key into map with key type " + this.keyType;
        }

        private String badValueMsg(Object value) {
            return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
        }

        CheckedMap(Map<K, V> m, Class<K> keyType, Class<V> valueType) {
            this.m = Objects.requireNonNull(m);
            this.keyType = Objects.requireNonNull(keyType);
            this.valueType = Objects.requireNonNull(valueType);
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object v) {
            return this.m.containsValue(v);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V remove(Object key) {
            return this.m.remove(key);
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.m.keySet();
        }

        @Override
        public Collection<V> values() {
            return this.m.values();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V put(K key, V value) {
            this.typeCheck(key, value);
            return this.m.put(key, value);
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> t) {
            Object[] entries = t.entrySet().toArray();
            ArrayList checked = new ArrayList(entries.length);
            for (Object o : entries) {
                Map.Entry e = (Map.Entry)o;
                Object k = e.getKey();
                Object v = e.getValue();
                this.typeCheck(k, v);
                checked.add(new AbstractMap.SimpleImmutableEntry(k, v));
            }
            for (Map.Entry entry : checked) {
                this.m.put(entry.getKey(), entry.getValue());
            }
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new CheckedEntrySet<K, V>(this.m.entrySet(), this.valueType);
            }
            return this.entrySet;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            this.m.replaceAll(this.typeCheck(function));
        }

        @Override
        public V putIfAbsent(K key, V value) {
            this.typeCheck(key, value);
            return this.m.putIfAbsent(key, value);
        }

        @Override
        public boolean remove(Object key, Object value) {
            return this.m.remove(key, value);
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            this.typeCheck(key, newValue);
            return this.m.replace(key, oldValue, newValue);
        }

        @Override
        public V replace(K key, V value) {
            this.typeCheck(key, value);
            return this.m.replace(key, value);
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Objects.requireNonNull(mappingFunction);
            return (V)this.m.computeIfAbsent(key, k -> {
                Object value = mappingFunction.apply((K)k);
                this.typeCheck(k, value);
                return value;
            });
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.m.computeIfPresent((K)key, this.typeCheck(remappingFunction));
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            return this.m.compute((K)key, this.typeCheck(remappingFunction));
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Objects.requireNonNull(remappingFunction);
            return (V)this.m.merge(key, value, (v1, v2) -> {
                Object newValue = remappingFunction.apply((V)v1, (V)v2);
                this.typeCheck(null, newValue);
                return newValue;
            });
        }

        static class CheckedEntrySet<K, V>
        implements Set<Map.Entry<K, V>> {
            private final Set<Map.Entry<K, V>> s;
            private final Class<V> valueType;

            CheckedEntrySet(Set<Map.Entry<K, V>> s, Class<V> valueType) {
                this.s = s;
                this.valueType = valueType;
            }

            @Override
            public int size() {
                return this.s.size();
            }

            @Override
            public boolean isEmpty() {
                return this.s.isEmpty();
            }

            public String toString() {
                return this.s.toString();
            }

            @Override
            public int hashCode() {
                return this.s.hashCode();
            }

            @Override
            public void clear() {
                this.s.clear();
            }

            @Override
            public boolean add(Map.Entry<K, V> e) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends Map.Entry<K, V>> coll) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                final Iterator<Map.Entry<K, V>> i = this.s.iterator();
                return new Iterator<Map.Entry<K, V>>(){

                    @Override
                    public boolean hasNext() {
                        return i.hasNext();
                    }

                    @Override
                    public void remove() {
                        i.remove();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return CheckedEntrySet.checkedEntry((Map.Entry)i.next(), valueType);
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        Objects.requireNonNull(action);
                        i.forEachRemaining((? super E e) -> action.accept(CheckedEntrySet.checkedEntry(e, valueType)));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] source = this.s.toArray();
                Object[] dest = source.getClass() == Object[].class ? source : new Object[source.length];
                for (int i = 0; i < source.length; ++i) {
                    dest[i] = CheckedEntrySet.checkedEntry((Map.Entry)source[i], this.valueType);
                }
                return dest;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.s.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = CheckedEntrySet.checkedEntry((Map.Entry)arr[i], this.valueType);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                CheckedEntry<K, V, V> e;
                return o instanceof Map.Entry && this.s.contains((e = (CheckedEntry<K, V, V>)o) instanceof CheckedEntry ? e : CheckedEntrySet.checkedEntry(e, this.valueType));
            }

            @Override
            public boolean containsAll(Collection<?> c) {
                for (Object o : c) {
                    if (this.contains(o)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean remove(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.s.remove(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
            }

            @Override
            public boolean removeAll(Collection<?> c) {
                return this.batchRemove(c, false);
            }

            @Override
            public boolean retainAll(Collection<?> c) {
                return this.batchRemove(c, true);
            }

            private boolean batchRemove(Collection<?> c, boolean complement) {
                Objects.requireNonNull(c);
                boolean modified = false;
                Iterator<Map.Entry<K, V>> it = this.iterator();
                while (it.hasNext()) {
                    if (c.contains(it.next()) == complement) continue;
                    it.remove();
                    modified = true;
                }
                return modified;
            }

            @Override
            public boolean equals(Object o) {
                Set that;
                if (o == this) {
                    return true;
                }
                return o instanceof Set && (that = (Set)o).size() == this.s.size() && this.containsAll(that);
            }

            static <K, V, T> CheckedEntry<K, V, T> checkedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                return new CheckedEntry<K, V, T>(e, valueType);
            }

            private static class CheckedEntry<K, V, T>
            implements Map.Entry<K, V> {
                private final Map.Entry<K, V> e;
                private final Class<T> valueType;

                CheckedEntry(Map.Entry<K, V> e, Class<T> valueType) {
                    this.e = Objects.requireNonNull(e);
                    this.valueType = Objects.requireNonNull(valueType);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                public String toString() {
                    return this.e.toString();
                }

                @Override
                public V setValue(V value) {
                    if (value != null && !this.valueType.isInstance(value)) {
                        throw new ClassCastException(this.badValueMsg(value));
                    }
                    return this.e.setValue(value);
                }

                private String badValueMsg(Object value) {
                    return "Attempt to insert " + value.getClass() + " value into map with value type " + this.valueType;
                }

                @Override
                public boolean equals(Object o) {
                    if (o == this) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    return this.e.equals(new AbstractMap.SimpleImmutableEntry((Map.Entry)o));
                }
            }
        }
    }

    static class CheckedRandomAccessList<E>
    extends CheckedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1638200125423088369L;

        CheckedRandomAccessList(List<E> list, Class<E> type) {
            super(list, type);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new CheckedRandomAccessList(this.list.subList(fromIndex, toIndex), this.type);
        }
    }

    static class CheckedSet<E>
    extends CheckedCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = 4694047833775013803L;

        CheckedSet(Set<E> s, Class<E> elementType) {
            super(s, elementType);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class CheckedSortedMap<K, V>
    extends CheckedMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = 1599671320688067438L;
        private final SortedMap<K, V> sm;

        CheckedSortedMap(SortedMap<K, V> m, Class<K> keyType, Class<V> valueType) {
            super(m, keyType, valueType);
            this.sm = m;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return Collections.checkedSortedMap(this.sm.subMap(fromKey, toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return Collections.checkedSortedMap(this.sm.headMap(toKey), this.keyType, this.valueType);
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return Collections.checkedSortedMap(this.sm.tailMap(fromKey), this.keyType, this.valueType);
        }
    }

    static class CheckedSortedSet<E>
    extends CheckedSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = 1599911165492914959L;
        private final SortedSet<E> ss;

        CheckedSortedSet(SortedSet<E> s, Class<E> type) {
            super(s, type);
            this.ss = s;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return Collections.checkedSortedSet(this.ss.subSet(fromElement, toElement), this.type);
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return Collections.checkedSortedSet(this.ss.headSet(toElement), this.type);
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return Collections.checkedSortedSet(this.ss.tailSet(fromElement), this.type);
        }
    }

    private static class CopiesList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 2739099268398711800L;
        final int n;
        final E element;

        CopiesList(int n, E e) {
            assert (n >= 0);
            this.n = n;
            this.element = e;
        }

        @Override
        public int size() {
            return this.n;
        }

        @Override
        public boolean contains(Object obj) {
            return this.n != 0 && Collections.eq(obj, this.element);
        }

        @Override
        public int indexOf(Object o) {
            return this.contains(o) ? 0 : -1;
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.contains(o) ? this.n - 1 : -1;
        }

        @Override
        public E get(int index) {
            Objects.checkIndex(index, this.n);
            return this.element;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            int n = this.n;
            E element = this.element;
            for (int i = 0; i < n; ++i) {
                action.accept(element);
            }
        }

        @Override
        public Object[] toArray() {
            Object[] a = new Object[this.n];
            if (this.element != null) {
                Arrays.fill(a, 0, this.n, this.element);
            }
            return a;
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int n = this.n;
            if (a.length < n) {
                a = (Object[])Array.newInstance(a.getClass().getComponentType(), n);
                if (this.element != null) {
                    Arrays.fill(a, 0, n, this.element);
                }
            } else {
                Arrays.fill(a, 0, n, this.element);
                if (a.length > n) {
                    a[n] = null;
                }
            }
            return a;
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            if (fromIndex < 0) {
                throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
            }
            if (toIndex > this.n) {
                throw new IndexOutOfBoundsException("toIndex = " + toIndex);
            }
            if (fromIndex > toIndex) {
                throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
            }
            return new CopiesList<E>(toIndex - fromIndex, this.element);
        }

        @Override
        public int hashCode() {
            if (this.n == 0) {
                return 1;
            }
            int pow = 31;
            int sum = 1;
            for (int i = Integer.numberOfLeadingZeros(this.n) + 1; i < 32; ++i) {
                sum *= pow + 1;
                pow *= pow;
                if (this.n << i >= 0) continue;
                pow *= 31;
                sum = sum * 31 + 1;
            }
            return pow + sum * (this.element == null ? 0 : this.element.hashCode());
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CopiesList) {
                CopiesList other = (CopiesList)o;
                return this.n == other.n && (this.n == 0 || Collections.eq(this.element, other.element));
            }
            if (!(o instanceof List)) {
                return false;
            }
            int remaining = this.n;
            E e = this.element;
            Iterator itr = ((List)o).iterator();
            if (e == null) {
                while (itr.hasNext() && remaining-- > 0) {
                    if (itr.next() == null) continue;
                    return false;
                }
            } else {
                while (itr.hasNext() && remaining-- > 0) {
                    if (e.equals(itr.next())) continue;
                    return false;
                }
            }
            return remaining == 0 && !itr.hasNext();
        }

        @Override
        public Stream<E> stream() {
            return IntStream.range(0, this.n).mapToObj(i -> this.element);
        }

        @Override
        public Stream<E> parallelStream() {
            return IntStream.range(0, this.n).parallel().mapToObj(i -> this.element);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.stream().spliterator();
        }

        private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
            ois.defaultReadObject();
            SharedSecrets.getJavaObjectInputStreamAccess().checkArray(ois, Object[].class, this.n);
        }
    }

    private static class EmptyList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 8842843931221139166L;

        private EmptyList() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public ListIterator<E> listIterator() {
            return Collections.emptyListIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public E get(int index) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 1;
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter);
            return false;
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Objects.requireNonNull(operator);
        }

        @Override
        public void sort(Comparator<? super E> c) {
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_LIST;
        }
    }

    private static class EmptyMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        private EmptyMap() {
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public V get(Object key) {
            return null;
        }

        @Override
        public Set<K> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<V> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }

        @Override
        public V getOrDefault(Object k, V defaultValue) {
            return defaultValue;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            Objects.requireNonNull(function);
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        private Object readResolve() {
            return EMPTY_MAP;
        }
    }

    private static class EmptySet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        private EmptySet() {
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.emptyIterator();
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean contains(Object obj) {
            return false;
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return c.isEmpty();
        }

        @Override
        public Object[] toArray() {
            return new Object[0];
        }

        @Override
        public <T> T[] toArray(T[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Objects.requireNonNull(filter);
            return false;
        }

        @Override
        public Spliterator<E> spliterator() {
            return Spliterators.emptySpliterator();
        }

        private Object readResolve() {
            return EMPTY_SET;
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    private static class ReverseComparator
    implements Comparator<Comparable<Object>>,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;
        static final ReverseComparator REVERSE_ORDER = new ReverseComparator();

        private ReverseComparator() {
        }

        @Override
        public int compare(Comparable<Object> c1, Comparable<Object> c2) {
            return c2.compareTo(c1);
        }

        private Object readResolve() {
            return Collections.reverseOrder();
        }

        @Override
        public Comparator<Comparable<Object>> reversed() {
            return Comparator.naturalOrder();
        }
    }

    private static class ReverseComparator2<T>
    implements Comparator<T>,
    Serializable {
        private static final long serialVersionUID = 4374092139857L;
        final Comparator<T> cmp;

        ReverseComparator2(Comparator<T> cmp) {
            assert (cmp != null);
            this.cmp = cmp;
        }

        @Override
        public int compare(T t1, T t2) {
            return this.cmp.compare(t2, t1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object o) {
            if (o == this) return true;
            if (!(o instanceof ReverseComparator2)) return false;
            ReverseComparator2 that = (ReverseComparator2)o;
            if (!this.cmp.equals(that.cmp)) return false;
            return true;
        }

        public int hashCode() {
            return this.cmp.hashCode() ^ Integer.MIN_VALUE;
        }

        @Override
        public Comparator<T> reversed() {
            return this.cmp;
        }
    }

    private static class SetFromMap<E>
    extends AbstractSet<E>
    implements Set<E>,
    Serializable {
        final Map<E, Boolean> m;
        private transient Set<E> s;
        private static final long serialVersionUID = 2454657854757543876L;

        SetFromMap(Map<E, Boolean> map) {
            this.m = map;
            this.s = map.keySet();
        }

        @Override
        public void clear() {
            this.m.clear();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.m.containsKey(o);
        }

        @Override
        public boolean remove(Object o) {
            return this.m.remove(o) != null;
        }

        @Override
        public boolean add(E e) {
            return this.m.put(e, Boolean.TRUE) == null;
        }

        @Override
        public Iterator<E> iterator() {
            return this.s.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.s.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.s.toArray(a);
        }

        @Override
        public String toString() {
            return this.s.toString();
        }

        @Override
        public int hashCode() {
            return this.s.hashCode();
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.s.equals(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.s.containsAll(c);
        }

        @Override
        public boolean removeAll(Collection<?> c) {
            return this.s.removeAll(c);
        }

        @Override
        public boolean retainAll(Collection<?> c) {
            return this.s.retainAll(c);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.s.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            return this.s.removeIf(filter);
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.s.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.s.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.s.parallelStream();
        }

        private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
            stream.defaultReadObject();
            this.s = this.m.keySet();
        }

        private void readObjectNoData() throws ObjectStreamException {
            throw new InvalidObjectException("missing SetFromMap data");
        }
    }

    private static class SingletonList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = 3093736618740652951L;
        private final E element;

        SingletonList(E obj) {
            this.element = obj;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object obj) {
            return Collections.eq(obj, this.element);
        }

        @Override
        public E get(int index) {
            if (index != 0) {
                throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
            }
            return this.element;
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            action.accept(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
        }

        @Override
        public Spliterator<E> spliterator() {
            return Collections.singletonSpliterator(this.element);
        }

        @Override
        public int hashCode() {
            return 31 + Objects.hashCode(this.element);
        }
    }

    private static class SingletonMap<K, V>
    extends AbstractMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final K k;
        private final V v;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SingletonMap(K key, V value) {
            this.k = key;
            this.v = value;
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean isEmpty() {
            return false;
        }

        @Override
        public boolean containsKey(Object key) {
            return Collections.eq(key, this.k);
        }

        @Override
        public boolean containsValue(Object value) {
            return Collections.eq(value, this.v);
        }

        @Override
        public V get(Object key) {
            return Collections.eq(key, this.k) ? (V)this.v : null;
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.singleton(this.k);
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = Collections.singleton(new AbstractMap.SimpleImmutableEntry<K, V>(this.k, this.v));
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            return Collections.eq(key, this.k) ? this.v : defaultValue;
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            action.accept(this.k, this.v);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.k) ^ Objects.hashCode(this.v);
        }
    }

    private static class SingletonSet<E>
    extends AbstractSet<E>
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        private final E element;

        SingletonSet(E e) {
            this.element = e;
        }

        @Override
        public Iterator<E> iterator() {
            return Collections.singletonIterator(this.element);
        }

        @Override
        public int size() {
            return 1;
        }

        @Override
        public boolean contains(Object o) {
            return Collections.eq(o, this.element);
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            action.accept(this.element);
        }

        @Override
        public Spliterator<E> spliterator() {
            return Collections.singletonSpliterator(this.element);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int hashCode() {
            return Objects.hashCode(this.element);
        }
    }

    static class SynchronizedCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection<E> c;
        final Object mutex;

        SynchronizedCollection(Collection<E> c) {
            this.c = Objects.requireNonNull(c);
            this.mutex = this;
        }

        SynchronizedCollection(Collection<E> c, Object mutex) {
            this.c = Objects.requireNonNull(c);
            this.mutex = Objects.requireNonNull(mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.contains(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(T[] a) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(a);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toArray(f);
            }
        }

        @Override
        public Iterator<E> iterator() {
            return this.c.iterator();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean add(E e) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.add(e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.remove(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.containsAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.addAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> coll) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.retainAll(coll);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.c.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(Consumer<? super E> consumer) {
            Object object = this.mutex;
            synchronized (object) {
                this.c.forEach(consumer);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.removeIf(filter);
            }
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class SynchronizedList<E>
    extends SynchronizedCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -7754090372962971524L;
        final List<E> list;

        SynchronizedList(List<E> list) {
            super(list);
            this.list = list;
        }

        SynchronizedList(List<E> list, Object mutex) {
            super(list, mutex);
            this.list = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.list.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.get(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E set(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.set(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void add(int index, E element) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.add(index, element);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.remove(index);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.indexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.lastIndexOf(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            Object object = this.mutex;
            synchronized (object) {
                return this.list.addAll(index, c);
            }
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.list.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.list.listIterator(index);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedList<E>(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.replaceAll(operator);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sort(Comparator<? super E> c) {
            Object object = this.mutex;
            synchronized (object) {
                this.list.sort(c);
            }
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new SynchronizedRandomAccessList<E>(this.list) : this;
        }
    }

    private static class SynchronizedMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map<K, V> m;
        final Object mutex;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        SynchronizedMap(Map<K, V> m) {
            this.m = Objects.requireNonNull(m);
            this.mutex = this;
        }

        SynchronizedMap(Map<K, V> m, Object mutex) {
            this.m = m;
            this.mutex = mutex;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.size();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.isEmpty();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsKey(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.containsValue(value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.get(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V put(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.put(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V remove(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.putAll(map);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                this.m.clear();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<K> keySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.keySet == null) {
                    this.keySet = new SynchronizedSet<K>(this.m.keySet(), this.mutex);
                }
                return this.keySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.entrySet == null) {
                    this.entrySet = new SynchronizedSet<Map.Entry<K, V>>(this.m.entrySet(), this.mutex);
                }
                return this.entrySet;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Collection<V> values() {
            Object object = this.mutex;
            synchronized (object) {
                if (this.values == null) {
                    this.values = new SynchronizedCollection<V>(this.m.values(), this.mutex);
                }
                return this.values;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.m.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.hashCode();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.toString();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V getOrDefault(Object k, V defaultValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.getOrDefault(k, defaultValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.forEach(action);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            Object object = this.mutex;
            synchronized (object) {
                this.m.replaceAll(function);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V putIfAbsent(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.putIfAbsent(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean remove(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.remove(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(key, oldValue, newValue);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V replace(K key, V value) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.replace(key, value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfAbsent((K)key, mappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.computeIfPresent((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.compute((K)key, (BiFunction<? super K, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            Object object = this.mutex;
            synchronized (object) {
                return this.m.merge(key, (V)value, (BiFunction<? extends V, ? extends V, ? extends V>)remappingFunction);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeObject(ObjectOutputStream s) throws IOException {
            Object object = this.mutex;
            synchronized (object) {
                s.defaultWriteObject();
            }
        }
    }

    static class SynchronizedRandomAccessList<E>
    extends SynchronizedList<E>
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List<E> list) {
            super(list);
        }

        SynchronizedRandomAccessList(List<E> list, Object mutex) {
            super(list, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedRandomAccessList(this.list.subList(fromIndex, toIndex), this.mutex);
            }
        }

        private Object writeReplace() {
            return new SynchronizedList(this.list);
        }
    }

    static class SynchronizedSet<E>
    extends SynchronizedCollection<E>
    implements Set<E> {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set<E> s) {
            super(s);
        }

        SynchronizedSet(Set<E> s, Object mutex) {
            super(s, mutex);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            Object object = this.mutex;
            synchronized (object) {
                return this.c.equals(o);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                return this.c.hashCode();
            }
        }
    }

    static class SynchronizedSortedMap<K, V>
    extends SynchronizedMap<K, V>
    implements SortedMap<K, V> {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap<K, V> sm;

        SynchronizedSortedMap(SortedMap<K, V> m) {
            super(m);
            this.sm = m;
        }

        SynchronizedSortedMap(SortedMap<K, V> m, Object mutex) {
            super(m, mutex);
            this.sm = m;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super K> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.subMap(fromKey, toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> headMap(K toKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.headMap(toKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedMap<K, V>(this.sm.tailMap(fromKey), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.firstKey();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public K lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                return this.sm.lastKey();
            }
        }
    }

    static class SynchronizedSortedSet<E>
    extends SynchronizedSet<E>
    implements SortedSet<E> {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet<E> ss;

        SynchronizedSortedSet(SortedSet<E> s) {
            super(s);
            this.ss = s;
        }

        SynchronizedSortedSet(SortedSet<E> s, Object mutex) {
            super(s, mutex);
            this.ss = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Comparator<? super E> comparator() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.comparator();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.subSet(fromElement, toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> headSet(E toElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.headSet(toElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SortedSet<E> tailSet(E fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                return new SynchronizedSortedSet<E>(this.ss.tailSet(fromElement), this.mutex);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E first() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.first();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public E last() {
            Object object = this.mutex;
            synchronized (object) {
                return this.ss.last();
            }
        }
    }

    static class UnmodifiableCollection<E>
    implements Collection<E>,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection<? extends E> c;

        UnmodifiableCollection(Collection<? extends E> c) {
            if (c == null) {
                throw new NullPointerException();
            }
            this.c = c;
        }

        @Override
        public int size() {
            return this.c.size();
        }

        @Override
        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        @Override
        public Object[] toArray() {
            return this.c.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.c.toArray(a);
        }

        @Override
        public <T> T[] toArray(IntFunction<T[]> f) {
            return this.c.toArray(f);
        }

        public String toString() {
            return this.c.toString();
        }

        @Override
        public Iterator<E> iterator() {
            return new Iterator<E>(){
                private final Iterator<? extends E> i;
                {
                    this.i = c.iterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public boolean add(E e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean containsAll(Collection<?> coll) {
            return this.c.containsAll(coll);
        }

        @Override
        public boolean addAll(Collection<? extends E> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection<?> coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEach(Consumer<? super E> action) {
            this.c.forEach(action);
        }

        @Override
        public boolean removeIf(Predicate<? super E> filter) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Spliterator<E> spliterator() {
            return this.c.spliterator();
        }

        @Override
        public Stream<E> stream() {
            return this.c.stream();
        }

        @Override
        public Stream<E> parallelStream() {
            return this.c.parallelStream();
        }
    }

    static class UnmodifiableList<E>
    extends UnmodifiableCollection<E>
    implements List<E> {
        private static final long serialVersionUID = -283967356065247728L;
        final List<? extends E> list;

        UnmodifiableList(List<? extends E> list) {
            super(list);
            this.list = list;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.list.equals(o);
        }

        @Override
        public int hashCode() {
            return this.list.hashCode();
        }

        @Override
        public E get(int index) {
            return this.list.get(index);
        }

        @Override
        public E set(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(int index, E element) {
            throw new UnsupportedOperationException();
        }

        @Override
        public E remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(UnaryOperator<E> operator) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void sort(Comparator<? super E> c) {
            throw new UnsupportedOperationException();
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.listIterator(0);
        }

        @Override
        public ListIterator<E> listIterator(final int index) {
            return new ListIterator<E>(){
                private final ListIterator<? extends E> i;
                {
                    this.i = list.listIterator(index);
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public E next() {
                    return this.i.next();
                }

                @Override
                public boolean hasPrevious() {
                    return this.i.hasPrevious();
                }

                @Override
                public E previous() {
                    return this.i.previous();
                }

                @Override
                public int nextIndex() {
                    return this.i.nextIndex();
                }

                @Override
                public int previousIndex() {
                    return this.i.previousIndex();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void set(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void add(E e) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public void forEachRemaining(Consumer<? super E> action) {
                    this.i.forEachRemaining(action);
                }
            };
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableList<E>(this.list.subList(fromIndex, toIndex));
        }

        private Object readResolve() {
            return this.list instanceof RandomAccess ? new UnmodifiableRandomAccessList<E>(this.list) : this;
        }
    }

    private static class UnmodifiableMap<K, V>
    implements Map<K, V>,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        final Map<? extends K, ? extends V> m;
        private transient Set<K> keySet;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Collection<V> values;

        UnmodifiableMap(Map<? extends K, ? extends V> m) {
            if (m == null) {
                throw new NullPointerException();
            }
            this.m = m;
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object val) {
            return this.m.containsValue(val);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            if (this.keySet == null) {
                this.keySet = Collections.unmodifiableSet(this.m.keySet());
            }
            return this.keySet;
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new UnmodifiableEntrySet<K, V>(this.m.entrySet());
            }
            return this.entrySet;
        }

        @Override
        public Collection<V> values() {
            if (this.values == null) {
                this.values = Collections.unmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        public String toString() {
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object k, V defaultValue) {
            return this.m.getOrDefault(k, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        static class UnmodifiableEntrySet<K, V>
        extends UnmodifiableSet<Map.Entry<K, V>> {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set<? extends Map.Entry<? extends K, ? extends V>> s) {
                super(s);
            }

            static <K, V> Consumer<Map.Entry<? extends K, ? extends V>> entryConsumer(Consumer<? super Map.Entry<K, V>> action) {
                return e -> action.accept(new UnmodifiableEntry(e));
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                Objects.requireNonNull(action);
                this.c.forEach(UnmodifiableEntrySet.entryConsumer(action));
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return new UnmodifiableEntrySetSpliterator(this.c.spliterator());
            }

            @Override
            public Stream<Map.Entry<K, V>> stream() {
                return StreamSupport.stream(this.spliterator(), false);
            }

            @Override
            public Stream<Map.Entry<K, V>> parallelStream() {
                return StreamSupport.stream(this.spliterator(), true);
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                return new Iterator<Map.Entry<K, V>>(){
                    private final Iterator<? extends Map.Entry<? extends K, ? extends V>> i;
                    {
                        this.i = c.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        return new UnmodifiableEntry(this.i.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                        Objects.requireNonNull(action);
                        this.i.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
                    }
                };
            }

            @Override
            public Object[] toArray() {
                Object[] a = this.c.toArray();
                for (int i = 0; i < a.length; ++i) {
                    a[i] = new UnmodifiableEntry((Map.Entry)a[i]);
                }
                return a;
            }

            @Override
            public <T> T[] toArray(T[] a) {
                T[] arr = this.c.toArray(a.length == 0 ? a : Arrays.copyOf(a, 0));
                for (int i = 0; i < arr.length; ++i) {
                    arr[i] = new UnmodifiableEntry((Map.Entry)arr[i]);
                }
                if (arr.length > a.length) {
                    return arr;
                }
                System.arraycopy(arr, 0, a, 0, arr.length);
                if (a.length > arr.length) {
                    a[arr.length] = null;
                }
                return a;
            }

            @Override
            public boolean contains(Object o) {
                if (!(o instanceof Map.Entry)) {
                    return false;
                }
                return this.c.contains(new UnmodifiableEntry((Map.Entry)o));
            }

            @Override
            public boolean containsAll(Collection<?> coll) {
                for (Object e : coll) {
                    if (this.contains(e)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean equals(Object o) {
                Set s;
                if (o == this) {
                    return true;
                }
                return o instanceof Set && (s = (Set)o).size() == this.c.size() && this.containsAll(s);
            }

            static final class UnmodifiableEntrySetSpliterator<K, V>
            implements Spliterator<Map.Entry<K, V>> {
                final Spliterator<Map.Entry<K, V>> s;

                UnmodifiableEntrySetSpliterator(Spliterator<Map.Entry<K, V>> s) {
                    this.s = s;
                }

                @Override
                public boolean tryAdvance(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    return this.s.tryAdvance(UnmodifiableEntrySet.entryConsumer(action));
                }

                @Override
                public void forEachRemaining(Consumer<? super Map.Entry<K, V>> action) {
                    Objects.requireNonNull(action);
                    this.s.forEachRemaining(UnmodifiableEntrySet.entryConsumer(action));
                }

                @Override
                public Spliterator<Map.Entry<K, V>> trySplit() {
                    Spliterator<Map.Entry<K, V>> split = this.s.trySplit();
                    return split == null ? null : new UnmodifiableEntrySetSpliterator<K, V>(split);
                }

                @Override
                public long estimateSize() {
                    return this.s.estimateSize();
                }

                @Override
                public long getExactSizeIfKnown() {
                    return this.s.getExactSizeIfKnown();
                }

                @Override
                public int characteristics() {
                    return this.s.characteristics();
                }

                @Override
                public boolean hasCharacteristics(int characteristics) {
                    return this.s.hasCharacteristics(characteristics);
                }

                @Override
                public Comparator<? super Map.Entry<K, V>> getComparator() {
                    return this.s.getComparator();
                }
            }

            private static class UnmodifiableEntry<K, V>
            implements Map.Entry<K, V> {
                private Map.Entry<? extends K, ? extends V> e;

                UnmodifiableEntry(Map.Entry<? extends K, ? extends V> e) {
                    this.e = Objects.requireNonNull(e);
                }

                @Override
                public K getKey() {
                    return this.e.getKey();
                }

                @Override
                public V getValue() {
                    return this.e.getValue();
                }

                @Override
                public V setValue(V value) {
                    throw new UnsupportedOperationException();
                }

                @Override
                public int hashCode() {
                    return this.e.hashCode();
                }

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Override
                public boolean equals(Object o) {
                    if (this == o) {
                        return true;
                    }
                    if (!(o instanceof Map.Entry)) return false;
                    Map.Entry t = (Map.Entry)o;
                    if (!Collections.eq(this.e.getKey(), t.getKey())) return false;
                    if (!Collections.eq(this.e.getValue(), t.getValue())) return false;
                    return true;
                }

                public String toString() {
                    return this.e.toString();
                }
            }
        }
    }

    static class UnmodifiableRandomAccessList<E>
    extends UnmodifiableList<E>
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List<? extends E> list) {
            super(list);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new UnmodifiableRandomAccessList(this.list.subList(fromIndex, toIndex));
        }

        private Object writeReplace() {
            return new UnmodifiableList(this.list);
        }
    }

    static class UnmodifiableSet<E>
    extends UnmodifiableCollection<E>
    implements Set<E>,
    Serializable {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set<? extends E> s) {
            super(s);
        }

        @Override
        public boolean equals(Object o) {
            return o == this || this.c.equals(o);
        }

        @Override
        public int hashCode() {
            return this.c.hashCode();
        }
    }

    static class UnmodifiableSortedMap<K, V>
    extends UnmodifiableMap<K, V>
    implements SortedMap<K, V>,
    Serializable {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap<K, ? extends V> sm;

        UnmodifiableSortedMap(SortedMap<K, ? extends V> m) {
            super(m);
            this.sm = m;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sm.comparator();
        }

        @Override
        public SortedMap<K, V> subMap(K fromKey, K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.subMap(fromKey, toKey));
        }

        @Override
        public SortedMap<K, V> headMap(K toKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.headMap(toKey));
        }

        @Override
        public SortedMap<K, V> tailMap(K fromKey) {
            return new UnmodifiableSortedMap<K, V>(this.sm.tailMap(fromKey));
        }

        @Override
        public K firstKey() {
            return this.sm.firstKey();
        }

        @Override
        public K lastKey() {
            return this.sm.lastKey();
        }
    }

    static class UnmodifiableSortedSet<E>
    extends UnmodifiableSet<E>
    implements SortedSet<E>,
    Serializable {
        private static final long serialVersionUID = -4929149591599911165L;
        private final SortedSet<E> ss;

        UnmodifiableSortedSet(SortedSet<E> s) {
            super(s);
            this.ss = s;
        }

        @Override
        public Comparator<? super E> comparator() {
            return this.ss.comparator();
        }

        @Override
        public SortedSet<E> subSet(E fromElement, E toElement) {
            return new UnmodifiableSortedSet<E>(this.ss.subSet(fromElement, toElement));
        }

        @Override
        public SortedSet<E> headSet(E toElement) {
            return new UnmodifiableSortedSet<E>(this.ss.headSet(toElement));
        }

        @Override
        public SortedSet<E> tailSet(E fromElement) {
            return new UnmodifiableSortedSet<E>(this.ss.tailSet(fromElement));
        }

        @Override
        public E first() {
            return this.ss.first();
        }

        @Override
        public E last() {
            return this.ss.last();
        }
    }
}

