/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Formatter;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class String
implements Serializable,
Comparable<String>,
CharSequence {
    private final char[] value;
    private final int offset;
    private final int count;
    private int hash;
    private static final long serialVersionUID = -6849794470754667710L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[0];
    public static final Comparator<String> CASE_INSENSITIVE_ORDER = new CaseInsensitiveComparator(null);

    public String() {
        this.offset = 0;
        this.count = 0;
        this.value = new char[0];
    }

    public String(String string) {
        char[] cArray;
        int n = string.count;
        char[] cArray2 = string.value;
        if (cArray2.length > n) {
            int n2 = string.offset;
            cArray = Arrays.copyOfRange(cArray2, n2, n2 + n);
        } else {
            cArray = cArray2;
        }
        this.offset = 0;
        this.count = n;
        this.value = cArray;
    }

    public String(char[] cArray) {
        this.offset = 0;
        this.count = cArray.length;
        this.value = StringValue.from((char[])cArray);
    }

    public String(char[] cArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > cArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        this.offset = 0;
        this.count = n2;
        this.value = Arrays.copyOfRange(cArray, n, n + n2);
    }

    public String(int[] nArray, int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > nArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
        int n3 = 0;
        int n4 = 1;
        char[] cArray = new char[n2 + n4];
        int n5 = n;
        int n6 = 0;
        for (int i = 0; i < n2; ++i) {
            int n7;
            if ((n7 = nArray[n5++]) < 0) {
                throw new IllegalArgumentException();
            }
            if (n4 <= 0 && n6 + 1 >= cArray.length) {
                if (n3 == 0) {
                    n3 = ((-n4 + 1) * n2 << 10) / i;
                    if ((n3 >>= 10) <= 0) {
                        n3 = 1;
                    }
                } else {
                    n3 *= 2;
                }
                int n8 = Math.min(cArray.length + n3, n2 * 2);
                n4 = n8 - cArray.length - (n2 - i);
                cArray = Arrays.copyOf(cArray, n8);
            }
            if (n7 < 65536) {
                cArray[n6++] = (char)n7;
                continue;
            }
            if (n7 <= 0x10FFFF) {
                Character.toSurrogates(n7, cArray, n6);
                n6 += 2;
                --n4;
                continue;
            }
            throw new IllegalArgumentException();
        }
        this.offset = 0;
        this.value = cArray;
        this.count = n6;
    }

    @Deprecated
    public String(byte[] byArray, int n, int n2, int n3) {
        String.checkBounds(byArray, n2, n3);
        char[] cArray = new char[n3];
        if (n == 0) {
            int n4 = n3;
            while (n4-- > 0) {
                cArray[n4] = (char)(byArray[n4 + n2] & 0xFF);
            }
        } else {
            n <<= 8;
            int n5 = n3;
            while (n5-- > 0) {
                cArray[n5] = (char)(n | byArray[n5 + n2] & 0xFF);
            }
        }
        this.offset = 0;
        this.count = n3;
        this.value = cArray;
    }

    @Deprecated
    public String(byte[] byArray, int n) {
        this(byArray, n, 0, byArray.length);
    }

    private static void checkBounds(byte[] byArray, int n, int n2) {
        if (n2 < 0) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n > byArray.length - n2) {
            throw new StringIndexOutOfBoundsException(n + n2);
        }
    }

    public String(byte[] byArray, int n, int n2, String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException("charsetName");
        }
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((String)string, (byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray, int n, int n2, Charset charset) {
        if (charset == null) {
            throw new NullPointerException("charset");
        }
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((Charset)charset, (byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray, String string) throws UnsupportedEncodingException {
        this(byArray, 0, byArray.length, string);
    }

    public String(byte[] byArray, Charset charset) {
        this(byArray, 0, byArray.length, charset);
    }

    public String(byte[] byArray, int n, int n2) {
        String.checkBounds(byArray, n, n2);
        char[] cArray = StringCoding.decode((byte[])byArray, (int)n, (int)n2);
        this.offset = 0;
        this.count = cArray.length;
        this.value = cArray;
    }

    public String(byte[] byArray) {
        this(byArray, 0, byArray.length);
    }

    public String(StringBuffer stringBuffer) {
        String string = stringBuffer.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    public String(StringBuilder stringBuilder) {
        String string = stringBuilder.toString();
        this.value = string.value;
        this.count = string.count;
        this.offset = string.offset;
    }

    String(int n, int n2, char[] cArray) {
        this.value = cArray;
        this.offset = n;
        this.count = n2;
    }

    @Override
    public int length() {
        return this.count;
    }

    @Override
    public boolean isEmpty() {
        return this.count == 0;
    }

    @Override
    public char charAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return this.value[n + this.offset];
    }

    public int codePointAt(int n) {
        if (n < 0 || n >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointAtImpl(this.value, this.offset + n, this.offset + this.count);
    }

    public int codePointBefore(int n) {
        int n2 = n - 1;
        if (n2 < 0 || n2 >= this.count) {
            throw new StringIndexOutOfBoundsException(n);
        }
        return Character.codePointBeforeImpl(this.value, this.offset + n, this.offset);
    }

    public int codePointCount(int n, int n2) {
        if (n < 0 || n2 > this.count || n > n2) {
            throw new IndexOutOfBoundsException();
        }
        return Character.codePointCountImpl(this.value, this.offset + n, n2 - n);
    }

    public int offsetByCodePoints(int n, int n2) {
        if (n < 0 || n > this.count) {
            throw new IndexOutOfBoundsException();
        }
        return Character.offsetByCodePointsImpl(this.value, this.offset, this.count, this.offset + n, n2) - this.offset;
    }

    void getChars(char[] cArray, int n) {
        System.arraycopy(this.value, this.offset, cArray, n, this.count);
    }

    public void getChars(int n, int n2, char[] cArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        System.arraycopy(this.value, this.offset + n, cArray, n3, n2 - n);
    }

    @Deprecated
    public void getBytes(int n, int n2, byte[] byArray, int n3) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        int n4 = n3;
        int n5 = this.offset + n2;
        int n6 = this.offset + n;
        char[] cArray = this.value;
        while (n6 < n5) {
            byArray[n4++] = (byte)cArray[n6++];
        }
    }

    public byte[] getBytes(String string) throws UnsupportedEncodingException {
        if (string == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode((String)string, (char[])this.value, (int)this.offset, (int)this.count);
    }

    public byte[] getBytes(Charset charset) {
        if (charset == null) {
            throw new NullPointerException();
        }
        return StringCoding.encode((Charset)charset, (char[])this.value, (int)this.offset, (int)this.count);
    }

    public byte[] getBytes() {
        return StringCoding.encode((char[])this.value, (int)this.offset, (int)this.count);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof String) {
            String string = (String)object;
            int n = this.count;
            if (n == string.count) {
                char[] cArray = this.value;
                char[] cArray2 = string.value;
                int n2 = this.offset;
                int n3 = string.offset;
                while (n-- != 0) {
                    if (cArray[n2++] == cArray2[n3++]) continue;
                    return false;
                }
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contentEquals(StringBuffer stringBuffer) {
        StringBuffer stringBuffer2 = stringBuffer;
        synchronized (stringBuffer2) {
            return this.contentEquals((CharSequence)stringBuffer);
        }
    }

    public boolean contentEquals(CharSequence charSequence) {
        int n;
        int n2;
        char[] cArray;
        if (this.count != charSequence.length()) {
            return false;
        }
        if (charSequence instanceof AbstractStringBuilder) {
            cArray = this.value;
            char[] cArray2 = ((AbstractStringBuilder)charSequence).getValue();
            n2 = this.offset;
            n = 0;
            int n3 = this.count;
            while (n3-- != 0) {
                if (cArray[n2++] == cArray2[n++]) continue;
                return false;
            }
        }
        if (charSequence.equals(this)) {
            return true;
        }
        cArray = this.value;
        int n4 = this.offset;
        n2 = 0;
        n = this.count;
        while (n-- != 0) {
            if (cArray[n4++] == charSequence.charAt(n2++)) continue;
            return false;
        }
        return true;
    }

    public boolean equalsIgnoreCase(String string) {
        return this == string ? true : string != null && string.count == this.count && this.regionMatches(true, 0, string, 0, this.count);
    }

    @Override
    public int compareTo(String string) {
        int n = this.count;
        int n2 = string.count;
        int n3 = Math.min(n, n2);
        char[] cArray = this.value;
        char[] cArray2 = string.value;
        int n4 = this.offset;
        int n5 = string.offset;
        if (n4 == n5) {
            int n6 = n3 + n4;
            for (int i = n4; i < n6; ++i) {
                char c = cArray[i];
                char c2 = cArray2[i];
                if (c == c2) continue;
                return c - c2;
            }
        } else {
            while (n3-- != 0) {
                char c;
                char c3;
                if ((c3 = cArray[n4++]) == (c = cArray2[n5++])) continue;
                return c3 - c;
            }
        }
        return n - n2;
    }

    public int compareToIgnoreCase(String string) {
        return CASE_INSENSITIVE_ORDER.compare(this, string);
    }

    public boolean regionMatches(int n, String string, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = this.offset + n;
        char[] cArray2 = string.value;
        int n5 = string.offset + n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.count - (long)n3 || (long)n2 > (long)string.count - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            if (cArray[n4++] == cArray2[n5++]) continue;
            return false;
        }
        return true;
    }

    public boolean regionMatches(boolean bl, int n, String string, int n2, int n3) {
        char[] cArray = this.value;
        int n4 = this.offset + n;
        char[] cArray2 = string.value;
        int n5 = string.offset + n2;
        if (n2 < 0 || n < 0 || (long)n > (long)this.count - (long)n3 || (long)n2 > (long)string.count - (long)n3) {
            return false;
        }
        while (n3-- > 0) {
            char c;
            char c2;
            char c3;
            char c4;
            if ((c4 = cArray[n4++]) == (c3 = cArray2[n5++]) || bl && ((c2 = Character.toUpperCase(c4)) == (c = Character.toUpperCase(c3)) || Character.toLowerCase(c2) == Character.toLowerCase(c))) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string, int n) {
        char[] cArray = this.value;
        int n2 = this.offset + n;
        char[] cArray2 = string.value;
        int n3 = string.offset;
        int n4 = string.count;
        if (n < 0 || n > this.count - n4) {
            return false;
        }
        while (--n4 >= 0) {
            if (cArray[n2++] == cArray2[n3++]) continue;
            return false;
        }
        return true;
    }

    public boolean startsWith(String string) {
        return this.startsWith(string, 0);
    }

    public boolean endsWith(String string) {
        return this.startsWith(string, this.count - string.count);
    }

    public int hashCode() {
        int n = this.hash;
        int n2 = this.count;
        if (n == 0 && n2 > 0) {
            int n3 = this.offset;
            char[] cArray = this.value;
            for (int i = 0; i < n2; ++i) {
                n = 31 * n + cArray[n3++];
            }
            this.hash = n;
        }
        return n;
    }

    public int indexOf(int n) {
        return this.indexOf(n, 0);
    }

    public int indexOf(int n, int n2) {
        int n3;
        int n4 = this.offset + this.count;
        char[] cArray = this.value;
        if (n2 < 0) {
            n2 = 0;
        } else if (n2 >= this.count) {
            return -1;
        }
        if (n < 65536) {
            for (n3 = this.offset + n2; n3 < n4; ++n3) {
                if (cArray[n3] != n) continue;
                return n3 - this.offset;
            }
            return -1;
        }
        if (n <= 0x10FFFF) {
            char[] cArray2 = Character.toChars(n);
            while (n3 < n4) {
                if (cArray[n3] == cArray2[0]) {
                    if (n3 + 1 == n4) break;
                    if (cArray[n3 + 1] == cArray2[1]) {
                        return n3 - this.offset;
                    }
                }
                ++n3;
            }
        }
        return -1;
    }

    public int lastIndexOf(int n) {
        return this.lastIndexOf(n, this.count - 1);
    }

    public int lastIndexOf(int n, int n2) {
        int n3;
        int n4 = this.offset;
        char[] cArray = this.value;
        if (n < 65536) {
            for (n3 = this.offset + (n2 >= this.count ? this.count - 1 : n2); n3 >= n4; --n3) {
                if (cArray[n3] != n) continue;
                return n3 - this.offset;
            }
            return -1;
        }
        int n5 = this.offset + this.count;
        if (n <= 0x10FFFF) {
            char[] cArray2 = Character.toChars(n);
            while (n3 >= n4) {
                if (cArray[n3] == cArray2[0]) {
                    if (n3 + 1 == n5) break;
                    if (cArray[n3 + 1] == cArray2[1]) {
                        return n3 - this.offset;
                    }
                }
                --n3;
            }
        }
        return -1;
    }

    public int indexOf(String string) {
        return this.indexOf(string, 0);
    }

    public int indexOf(String string, int n) {
        return String.indexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n);
    }

    static int indexOf(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        if (n5 >= n2) {
            return n4 == 0 ? n2 : -1;
        }
        if (n5 < 0) {
            n5 = 0;
        }
        if (n4 == 0) {
            return n5;
        }
        char c = cArray2[n3];
        int n6 = n + (n2 - n4);
        for (int i = n + n5; i <= n6; ++i) {
            if (cArray[i] != c) {
                while (++i <= n6 && cArray[i] != c) {
                }
            }
            if (i > n6) continue;
            int n7 = i + 1;
            int n8 = n7 + n4 - 1;
            int n9 = n3 + 1;
            while (n7 < n8 && cArray[n7] == cArray2[n9]) {
                ++n7;
                ++n9;
            }
            if (n7 != n8) continue;
            return i - n;
        }
        return -1;
    }

    public int lastIndexOf(String string) {
        return this.lastIndexOf(string, this.count);
    }

    public int lastIndexOf(String string, int n) {
        return String.lastIndexOf(this.value, this.offset, this.count, string.value, string.offset, string.count, n);
    }

    static int lastIndexOf(char[] cArray, int n, int n2, char[] cArray2, int n3, int n4, int n5) {
        int n6;
        int n7 = n2 - n4;
        if (n5 < 0) {
            return -1;
        }
        if (n5 > n7) {
            n5 = n7;
        }
        if (n4 == 0) {
            return n5;
        }
        int n8 = n3 + n4 - 1;
        char c = cArray2[n8];
        int n9 = n + n4 - 1;
        int n10 = n9 + n5;
        block0: while (true) {
            if (n10 >= n9 && cArray[n10] != c) {
                --n10;
                continue;
            }
            if (n10 < n9) {
                return -1;
            }
            int n11 = n10 - 1;
            n6 = n11 - (n4 - 1);
            int n12 = n8 - 1;
            while (n11 > n6) {
                if (cArray[n11--] == cArray2[n12--]) continue;
                --n10;
                continue block0;
            }
            break;
        }
        return n6 - n + 1;
    }

    public String substring(int n) {
        return this.substring(n, this.count);
    }

    public String substring(int n, int n2) {
        if (n < 0) {
            throw new StringIndexOutOfBoundsException(n);
        }
        if (n2 > this.count) {
            throw new StringIndexOutOfBoundsException(n2);
        }
        if (n > n2) {
            throw new StringIndexOutOfBoundsException(n2 - n);
        }
        return n == 0 && n2 == this.count ? this : new String(this.offset + n, n2 - n, this.value);
    }

    @Override
    public CharSequence subSequence(int n, int n2) {
        return this.substring(n, n2);
    }

    public String concat(String string) {
        int n = string.length();
        if (n == 0) {
            return this;
        }
        char[] cArray = new char[this.count + n];
        this.getChars(0, this.count, cArray, 0);
        string.getChars(0, n, cArray, this.count);
        return new String(0, this.count + n, cArray);
    }

    public String replace(char c, char n) {
        if (c != n) {
            int n2 = this.count;
            int n3 = -1;
            char[] cArray = this.value;
            int n4 = this.offset;
            while (++n3 < n2 && cArray[n4 + n3] != c) {
            }
            if (n3 < n2) {
                int n5;
                char[] cArray2 = new char[n2];
                for (n5 = 0; n5 < n3; ++n5) {
                    cArray2[n5] = cArray[n4 + n5];
                }
                while (n3 < n2) {
                    n5 = cArray[n4 + n3];
                    cArray2[n3] = n5 == c ? n : n5;
                    ++n3;
                }
                return new String(0, n2, cArray2);
            }
        }
        return this;
    }

    public boolean matches(String string) {
        return Pattern.matches(string, this);
    }

    public boolean contains(CharSequence charSequence) {
        return this.indexOf(((Object)charSequence).toString()) > -1;
    }

    public String replaceFirst(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceFirst(string2);
    }

    public String replaceAll(String string, String string2) {
        return Pattern.compile(string).matcher(this).replaceAll(string2);
    }

    public String replace(CharSequence charSequence, CharSequence charSequence2) {
        return Pattern.compile(((Object)charSequence).toString(), 16).matcher(this).replaceAll(Matcher.quoteReplacement(((Object)charSequence2).toString()));
    }

    public String[] split(String string, int n) {
        return Pattern.compile(string).split(this, n);
    }

    public String[] split(String string) {
        return this.split(string, 0);
    }

    public String toLowerCase(Locale locale) {
        int n;
        int n2;
        int n3;
        block15: {
            if (locale == null) {
                throw new NullPointerException();
            }
            n3 = 0;
            while (n3 < this.count) {
                char c = this.value[this.offset + n3];
                if (c >= '\ud800' && c <= '\udbff') {
                    n2 = this.codePointAt(n3);
                    if (n2 == Character.toLowerCase(n2)) {
                        n3 += Character.charCount(n2);
                        continue;
                    }
                } else if (c == Character.toLowerCase(c)) {
                    ++n3;
                    continue;
                }
                break block15;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        n2 = 0;
        System.arraycopy(this.value, this.offset, cArray, 0, n3);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n3; i < this.count; i += n) {
            int n4 = this.value[this.offset + i];
            if ((char)n4 >= '\ud800' && (char)n4 <= '\udbff') {
                n4 = this.codePointAt(i);
                n = Character.charCount(n4);
            } else {
                n = 1;
            }
            int n5 = bl || n4 == 931 ? ConditionalSpecialCasing.toLowerCaseEx(this, i, locale) : Character.toLowerCase(n4);
            if (n5 == -1 || n5 >= 65536) {
                char[] cArray2;
                if (n5 == -1) {
                    cArray2 = ConditionalSpecialCasing.toLowerCaseCharArray(this, i, locale);
                } else {
                    if (n == 2) {
                        n2 += Character.toChars(n5, cArray, i + n2) - n;
                        continue;
                    }
                    cArray2 = Character.toChars(n5);
                }
                int n6 = cArray2.length;
                if (n6 > n) {
                    char[] cArray3 = new char[cArray.length + n6 - n];
                    System.arraycopy(cArray, 0, cArray3, 0, i + n2);
                    cArray = cArray3;
                }
                for (int j = 0; j < n6; ++j) {
                    cArray[i + n2 + j] = cArray2[j];
                }
                n2 += n6 - n;
                continue;
            }
            cArray[i + n2] = (char)n5;
        }
        return new String(0, this.count + n2, cArray);
    }

    public String toLowerCase() {
        return this.toLowerCase(Locale.getDefault());
    }

    public String toUpperCase(Locale locale) {
        int n;
        int n2;
        int n3;
        block14: {
            if (locale == null) {
                throw new NullPointerException();
            }
            for (n2 = 0; n2 < this.count; n2 += n3) {
                int n4 = this.value[this.offset + n2];
                if (n4 >= 55296 && n4 <= 56319) {
                    n4 = this.codePointAt(n2);
                    n3 = Character.charCount(n4);
                } else {
                    n3 = 1;
                }
                int n5 = Character.toUpperCaseEx(n4);
                if (n5 != -1 && n4 == n5) {
                    continue;
                }
                break block14;
            }
            return this;
        }
        char[] cArray = new char[this.count];
        n3 = 0;
        System.arraycopy(this.value, this.offset, cArray, 0, n2);
        String string = locale.getLanguage();
        boolean bl = string == "tr" || string == "az" || string == "lt";
        for (int i = n2; i < this.count; i += n) {
            int n6 = this.value[this.offset + i];
            if ((char)n6 >= '\ud800' && (char)n6 <= '\udbff') {
                n6 = this.codePointAt(i);
                n = Character.charCount(n6);
            } else {
                n = 1;
            }
            int n7 = bl ? ConditionalSpecialCasing.toUpperCaseEx(this, i, locale) : Character.toUpperCaseEx(n6);
            if (n7 == -1 || n7 >= 65536) {
                char[] cArray2;
                if (n7 == -1) {
                    cArray2 = bl ? ConditionalSpecialCasing.toUpperCaseCharArray(this, i, locale) : Character.toUpperCaseCharArray(n6);
                } else {
                    if (n == 2) {
                        n3 += Character.toChars(n7, cArray, i + n3) - n;
                        continue;
                    }
                    cArray2 = Character.toChars(n7);
                }
                int n8 = cArray2.length;
                if (n8 > n) {
                    char[] cArray3 = new char[cArray.length + n8 - n];
                    System.arraycopy(cArray, 0, cArray3, 0, i + n3);
                    cArray = cArray3;
                }
                for (int j = 0; j < n8; ++j) {
                    cArray[i + n3 + j] = cArray2[j];
                }
                n3 += n8 - n;
                continue;
            }
            cArray[i + n3] = (char)n7;
        }
        return new String(0, this.count + n3, cArray);
    }

    public String toUpperCase() {
        return this.toUpperCase(Locale.getDefault());
    }

    public String trim() {
        int n;
        int n2 = this.count;
        int n3 = this.offset;
        char[] cArray = this.value;
        for (n = 0; n < n2 && cArray[n3 + n] <= ' '; ++n) {
        }
        while (n < n2 && cArray[n3 + n2 - 1] <= ' ') {
            --n2;
        }
        return n > 0 || n2 < this.count ? this.substring(n, n2) : this;
    }

    @Override
    public String toString() {
        return this;
    }

    public char[] toCharArray() {
        char[] cArray = new char[this.count];
        this.getChars(0, this.count, cArray, 0);
        return cArray;
    }

    public static String format(String string, Object ... objectArray) {
        return new Formatter().format(string, objectArray).toString();
    }

    public static String format(Locale locale, String string, Object ... objectArray) {
        return new Formatter(locale).format(string, objectArray).toString();
    }

    public static String valueOf(Object object) {
        return object == null ? "null" : object.toString();
    }

    public static String valueOf(char[] cArray) {
        return new String(cArray);
    }

    public static String valueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray, int n, int n2) {
        return new String(cArray, n, n2);
    }

    public static String copyValueOf(char[] cArray) {
        return String.copyValueOf(cArray, 0, cArray.length);
    }

    public static String valueOf(boolean bl) {
        return bl ? "true" : "false";
    }

    public static String valueOf(char c) {
        char[] cArray = new char[]{c};
        return new String(0, 1, cArray);
    }

    public static String valueOf(int n) {
        return Integer.toString(n, 10);
    }

    public static String valueOf(long l) {
        return Long.toString(l, 10);
    }

    public static String valueOf(float f) {
        return Float.toString(f);
    }

    public static String valueOf(double d) {
        return Double.toString(d);
    }

    public native String intern();

    private static class CaseInsensitiveComparator
    implements Comparator<String>,
    Serializable {
        private static final long serialVersionUID = 8575799808933029326L;

        private CaseInsensitiveComparator() {
        }

        @Override
        public int compare(String s1, String s2) {
            byte[] v1 = s1.value;
            byte[] v2 = s2.value;
            byte coder = s1.coder();
            if (coder == s2.coder()) {
                return coder == 0 ? StringLatin1.compareToCI(v1, v2) : StringUTF16.compareToCI(v1, v2);
            }
            return coder == 0 ? StringLatin1.compareToCI_UTF16(v1, v2) : StringUTF16.compareToCI_Latin1(v1, v2);
        }

        private Object readResolve() {
            return String.CASE_INSENSITIVE_ORDER;
        }
    }
}

