/*
 * Decompiled with CFR 0.152.
 */
package java.lang;

import java.io.Serializable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Boolean
implements Serializable,
Comparable<Boolean> {
    public static final Boolean TRUE = new Boolean(true);
    public static final Boolean FALSE = new Boolean(false);
    public static final Class<Boolean> TYPE = Class.getPrimitiveClass("boolean");
    private final boolean value;
    private static final long serialVersionUID = -3665804199014368530L;

    public Boolean(boolean bl) {
        this.value = bl;
    }

    public Boolean(String string) {
        this(Boolean.toBoolean(string));
    }

    public static boolean parseBoolean(String string) {
        return Boolean.toBoolean(string);
    }

    public boolean booleanValue() {
        return this.value;
    }

    public static Boolean valueOf(boolean bl) {
        return bl ? TRUE : FALSE;
    }

    public static Boolean valueOf(String string) {
        return Boolean.toBoolean(string) ? TRUE : FALSE;
    }

    public static String toString(boolean bl) {
        return bl ? "true" : "false";
    }

    public String toString() {
        return this.value ? "true" : "false";
    }

    public int hashCode() {
        return this.value ? 1231 : 1237;
    }

    public boolean equals(Object object) {
        if (object instanceof Boolean) {
            return this.value == (Boolean)object;
        }
        return false;
    }

    public static boolean getBoolean(String string) {
        boolean bl = false;
        try {
            bl = Boolean.toBoolean(System.getProperty(string));
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return bl;
    }

    @Override
    public int compareTo(Boolean bl) {
        return bl.value == this.value ? 0 : (this.value ? 1 : -1);
    }

    private static boolean toBoolean(String string) {
        return string != null && string.equalsIgnoreCase("true");
    }
}

