/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    volatile transient int modCount;
    private transient Set<Map.Entry<K, V>> entrySet = null;
    private static final long serialVersionUID = 362498820763181265L;

    public HashMap(int n, float f) {
        int n2;
        if (n < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + n);
        }
        if (n > 0x40000000) {
            n = 0x40000000;
        }
        if (f <= 0.0f || Float.isNaN(f)) {
            throw new IllegalArgumentException("Illegal load factor: " + f);
        }
        for (n2 = 1; n2 < n; n2 <<= 1) {
        }
        this.loadFactor = f;
        this.threshold = (int)((float)n2 * f);
        this.table = new Entry[n2];
        this.init();
    }

    public HashMap(int n) {
        this(n, 0.75f);
    }

    public HashMap() {
        this.loadFactor = 0.75f;
        this.threshold = 12;
        this.table = new Entry[16];
        this.init();
    }

    public HashMap(Map<? extends K, ? extends V> map) {
        this(Math.max((int)((float)map.size() / 0.75f) + 1, 16), 0.75f);
        super.putAllForCreate(map);
    }

    void init() {
    }

    static int hash(int n) {
        n ^= n >>> 20 ^ n >>> 12;
        return n ^ n >>> 7 ^ n >>> 4;
    }

    static int indexFor(int n, int n2) {
        return n & n2 - 1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public V get(Object object) {
        if (object == null) {
            return this.getForNullKey();
        }
        int n = HashMap.hash(object.hashCode());
        Entry entry = this.table[HashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object object2;
            if (entry.hash == n && ((object2 = entry.key) == object || object.equals(object2))) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    private V getForNullKey() {
        Entry entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                return (V)entry.value;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public boolean containsKey(Object object) {
        return this.getEntry(object) != null;
    }

    final Entry<K, V> getEntry(Object object) {
        int n = object == null ? 0 : HashMap.hash(object.hashCode());
        Entry entry = this.table[HashMap.indexFor(n, this.table.length)];
        while (entry != null) {
            Object object2;
            if (entry.hash == n && ((object2 = entry.key) == object || object != null && object.equals(object2))) {
                return entry;
            }
            entry = entry.next;
        }
        return null;
    }

    @Override
    public V put(K k, V v) {
        if (k == null) {
            return this.putForNullKey(v);
        }
        int n = HashMap.hash(k.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            Object object;
            if (entry.hash == n && ((object = entry.key) == k || k.equals(object))) {
                Object object2 = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return (V)object2;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(n, k, v, n2);
        return null;
    }

    private V putForNullKey(V v) {
        Entry entry = this.table[0];
        while (entry != null) {
            if (entry.key == null) {
                Object object = entry.value;
                entry.value = v;
                entry.recordAccess(this);
                return (V)object;
            }
            entry = entry.next;
        }
        ++this.modCount;
        this.addEntry(0, null, v, 0);
        return null;
    }

    private void putForCreate(K k, V v) {
        int n = k == null ? 0 : HashMap.hash(k.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry = this.table[n2];
        while (entry != null) {
            Object object;
            if (entry.hash == n && ((object = entry.key) == k || k != null && k.equals(object))) {
                entry.value = v;
                return;
            }
            entry = entry.next;
        }
        this.createEntry(n, k, v, n2);
    }

    private void putAllForCreate(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.putForCreate(entry.getKey(), entry.getValue());
        }
    }

    void resize(int n) {
        Entry[] entryArray = this.table;
        int n2 = entryArray.length;
        if (n2 == 0x40000000) {
            this.threshold = Integer.MAX_VALUE;
            return;
        }
        Entry[] entryArray2 = new Entry[n];
        this.transfer(entryArray2);
        this.table = entryArray2;
        this.threshold = (int)((float)n * this.loadFactor);
    }

    void transfer(Entry[] entryArray) {
        Entry[] entryArray2 = this.table;
        int n = entryArray.length;
        for (int i = 0; i < entryArray2.length; ++i) {
            Entry entry;
            Entry entry2 = entryArray2[i];
            if (entry2 == null) continue;
            entryArray2[i] = null;
            do {
                entry = entry2.next;
                int n2 = HashMap.indexFor(entry2.hash, n);
                entry2.next = entryArray[n2];
                entryArray[n2] = entry2;
            } while ((entry2 = entry) != null);
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        int n = map.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            int n2;
            int n3 = (int)((float)n / this.loadFactor + 1.0f);
            if (n3 > 0x40000000) {
                n3 = 0x40000000;
            }
            for (n2 = this.table.length; n2 < n3; n2 <<= 1) {
            }
            if (n2 > this.table.length) {
                this.resize(n2);
            }
        }
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Entry<K, V> entry = this.removeEntryForKey(object);
        return (V)(entry == null ? null : entry.value);
    }

    final Entry<K, V> removeEntryForKey(Object object) {
        Entry entry;
        int n = object == null ? 0 : HashMap.hash(object.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry2 = entry = this.table[n2];
        while (entry2 != null) {
            Object object2;
            Entry entry3 = entry2.next;
            if (entry2.hash == n && ((object2 = entry2.key) == object || object != null && object.equals(object2))) {
                ++this.modCount;
                --this.size;
                if (entry == entry2) {
                    this.table[n2] = entry3;
                } else {
                    entry.next = entry3;
                }
                entry2.recordRemoval(this);
                return entry2;
            }
            entry = entry2;
            entry2 = entry3;
        }
        return entry2;
    }

    final Entry<K, V> removeMapping(Object object) {
        Entry entry;
        if (!(object instanceof Map.Entry)) {
            return null;
        }
        Map.Entry entry2 = (Map.Entry)object;
        Object k = entry2.getKey();
        int n = k == null ? 0 : HashMap.hash(k.hashCode());
        int n2 = HashMap.indexFor(n, this.table.length);
        Entry entry3 = entry = this.table[n2];
        while (entry3 != null) {
            Entry entry4 = entry3.next;
            if (entry3.hash == n && entry3.equals((Object)entry2)) {
                ++this.modCount;
                --this.size;
                if (entry == entry3) {
                    this.table[n2] = entry4;
                } else {
                    entry.next = entry4;
                }
                entry3.recordRemoval(this);
                return entry3;
            }
            entry = entry3;
            entry3 = entry4;
        }
        return entry3;
    }

    @Override
    public void clear() {
        ++this.modCount;
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            entryArray[i] = null;
        }
        this.size = 0;
    }

    @Override
    public boolean containsValue(Object object) {
        if (object == null) {
            return this.containsNullValue();
        }
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (object.equals(entry.value)) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    private boolean containsNullValue() {
        Entry[] entryArray = this.table;
        for (int i = 0; i < entryArray.length; ++i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                if (entry.value == null) {
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public Object clone() {
        HashMap hashMap = null;
        try {
            hashMap = (HashMap)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        hashMap.table = new Entry[this.table.length];
        hashMap.entrySet = null;
        hashMap.modCount = 0;
        hashMap.size = 0;
        hashMap.init();
        hashMap.putAllForCreate(this);
        return hashMap;
    }

    void addEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        this.table[n2] = new Entry(n, k, v, entry);
        if (this.size++ >= this.threshold) {
            this.resize(2 * this.table.length);
        }
    }

    void createEntry(int n, K k, V v, int n2) {
        Entry entry = this.table[n2];
        this.table[n2] = new Entry(n, k, v, entry);
        ++this.size;
    }

    Iterator<K> newKeyIterator() {
        return new KeyIterator(this, null);
    }

    Iterator<V> newValueIterator() {
        return new ValueIterator(this, null);
    }

    Iterator<Map.Entry<K, V>> newEntryIterator() {
        return new EntryIterator(this, null);
    }

    @Override
    public Set<K> keySet() {
        Set set = this.keySet;
        return set != null ? set : (this.keySet = new KeySet(this, null));
    }

    @Override
    public Collection<V> values() {
        Collection collection = this.values;
        return collection != null ? collection : (this.values = new Values(this, null));
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet0();
    }

    private Set<Map.Entry<K, V>> entrySet0() {
        EntrySet entrySet = this.entrySet;
        return entrySet != null ? entrySet : (this.entrySet = new EntrySet(this, null));
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Iterator<Map.Entry<K, V>> iterator = this.size > 0 ? this.entrySet0().iterator() : null;
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.table.length);
        objectOutputStream.writeInt(this.size);
        if (iterator != null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                objectOutputStream.writeObject(entry.getKey());
                objectOutputStream.writeObject(entry.getValue());
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.table = new Entry[n];
        this.init();
        int n2 = objectInputStream.readInt();
        for (int i = 0; i < n2; ++i) {
            Object object = objectInputStream.readObject();
            Object object2 = objectInputStream.readObject();
            this.putForCreate(object, object2);
        }
    }

    int capacity() {
        return this.table.length;
    }

    float loadFactor() {
        return this.loadFactor;
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(HashMap this$0) {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = HashMap.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return HashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        @Override
        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept((Map.Entry)e);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Entry[] t = HashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMap.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Entry[] t = HashMap.this.table;
                if (HashMap.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            HashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator(HashMap this$0) {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return HashMap.this.removeNode(HashMap.hash((Object)key), key, null, false, true) != null;
        }

        @Override
        public final Spliterator<K> spliterator() {
            return new KeySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.keysToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.keysToArray(HashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator(HashMap this$0) {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        @Override
        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.valuesToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.valuesToArray(HashMap.this.prepareArray(a));
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }
}

