/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkedList<E>
extends AbstractSequentialList<E>
implements List<E>,
Deque<E>,
Cloneable,
Serializable {
    private transient Entry<E> header = new Entry(null, null, null);
    private transient int size = 0;
    private static final long serialVersionUID = 876323262645176354L;

    public LinkedList() {
        this.header.next = this.header.previous = this.header;
    }

    public LinkedList(Collection<? extends E> collection) {
        this();
        this.addAll(collection);
    }

    @Override
    public E getFirst() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.header.next.element;
    }

    @Override
    public E getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return (E)this.header.previous.element;
    }

    @Override
    public E removeFirst() {
        return this.remove(this.header.next);
    }

    @Override
    public E removeLast() {
        return this.remove(this.header.previous);
    }

    @Override
    public void addFirst(E e) {
        this.addBefore(e, this.header.next);
    }

    @Override
    public void addLast(E e) {
        this.addBefore(e, this.header);
    }

    @Override
    public boolean contains(Object object) {
        return this.indexOf(object) != -1;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean add(E e) {
        this.addBefore(e, this.header);
        return true;
    }

    @Override
    public boolean remove(Object object) {
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.next;
            }
        }
        return false;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        return this.addAll(this.size, collection);
    }

    @Override
    public boolean addAll(int n, Collection<? extends E> collection) {
        if (n < 0 || n > this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Object[] objectArray = collection.toArray();
        int n2 = objectArray.length;
        if (n2 == 0) {
            return false;
        }
        ++this.modCount;
        Entry<E> entry = n == this.size ? this.header : this.entry(n);
        Entry entry2 = entry.previous;
        for (int i = 0; i < n2; ++i) {
            Entry entry3;
            entry2.next = entry3 = new Entry(objectArray[i], entry, entry2);
            entry2 = entry3;
        }
        entry.previous = entry2;
        this.size += n2;
        return true;
    }

    @Override
    public void clear() {
        Entry entry = this.header.next;
        while (entry != this.header) {
            Entry entry2 = entry.next;
            entry.previous = null;
            entry.next = null;
            entry.element = null;
            entry = entry2;
        }
        this.header.next = this.header.previous = this.header;
        this.size = 0;
        ++this.modCount;
    }

    @Override
    public E get(int n) {
        return (E)this.entry((int)n).element;
    }

    @Override
    public E set(int n, E e) {
        Entry<E> entry = this.entry(n);
        Object object = entry.element;
        entry.element = e;
        return (E)object;
    }

    @Override
    public void add(int n, E e) {
        this.addBefore(e, n == this.size ? this.header : this.entry(n));
    }

    @Override
    public E remove(int n) {
        return this.remove(this.entry(n));
    }

    private Entry<E> entry(int n) {
        if (n < 0 || n >= this.size) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Size: " + this.size);
        }
        Entry entry = this.header;
        if (n < this.size >> 1) {
            for (int i = 0; i <= n; ++i) {
                entry = entry.next;
            }
        } else {
            for (int i = this.size; i > n; --i) {
                entry = entry.previous;
            }
        }
        return entry;
    }

    @Override
    public int indexOf(Object object) {
        int n = 0;
        if (object == null) {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (entry.element == null) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        } else {
            Entry entry = this.header.next;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    return n;
                }
                ++n;
                entry = entry.next;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object object) {
        int n = this.size;
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (entry.element == null) {
                    return n;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                --n;
                if (object.equals(entry.element)) {
                    return n;
                }
                entry = entry.previous;
            }
        }
        return -1;
    }

    @Override
    public E peek() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E element() {
        return this.getFirst();
    }

    @Override
    public E poll() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E remove() {
        return this.removeFirst();
    }

    @Override
    public boolean offer(E e) {
        return this.add(e);
    }

    @Override
    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E peekFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.getFirst();
    }

    @Override
    public E peekLast() {
        if (this.size == 0) {
            return null;
        }
        return this.getLast();
    }

    @Override
    public E pollFirst() {
        if (this.size == 0) {
            return null;
        }
        return this.removeFirst();
    }

    @Override
    public E pollLast() {
        if (this.size == 0) {
            return null;
        }
        return this.removeLast();
    }

    @Override
    public void push(E e) {
        this.addFirst(e);
    }

    @Override
    public E pop() {
        return this.removeFirst();
    }

    @Override
    public boolean removeFirstOccurrence(Object object) {
        return this.remove(object);
    }

    @Override
    public boolean removeLastOccurrence(Object object) {
        if (object == null) {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                if (entry.element == null) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.previous;
            }
        } else {
            Entry entry = this.header.previous;
            while (entry != this.header) {
                if (object.equals(entry.element)) {
                    this.remove(entry);
                    return true;
                }
                entry = entry.previous;
            }
        }
        return false;
    }

    @Override
    public ListIterator<E> listIterator(int n) {
        return new ListItr(n);
    }

    private Entry<E> addBefore(E e, Entry<E> entry) {
        Entry entry2;
        entry2.previous.next = entry2 = new Entry(e, entry, entry.previous);
        entry2.next.previous = entry2;
        ++this.size;
        ++this.modCount;
        return entry2;
    }

    private E remove(Entry<E> entry) {
        if (entry == this.header) {
            throw new NoSuchElementException();
        }
        Object object = entry.element;
        entry.previous.next = entry.next;
        entry.next.previous = entry.previous;
        entry.previous = null;
        entry.next = null;
        entry.element = null;
        --this.size;
        ++this.modCount;
        return (E)object;
    }

    @Override
    public Iterator<E> descendingIterator() {
        return new DescendingIterator(this, null);
    }

    public Object clone() {
        LinkedList linkedList = null;
        try {
            linkedList = (LinkedList)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
        linkedList.header = new Entry(null, null, null);
        linkedList.header.next = linkedList.header.previous = linkedList.header;
        linkedList.size = 0;
        linkedList.modCount = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            linkedList.add(entry.element);
            entry = entry.next;
        }
        return linkedList;
    }

    @Override
    public Object[] toArray() {
        Object[] objectArray = new Object[this.size];
        int n = 0;
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectArray[n++] = entry.element;
            entry = entry.next;
        }
        return objectArray;
    }

    @Override
    public <T> T[] toArray(T[] objectArray) {
        if (objectArray.length < this.size) {
            objectArray = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), this.size);
        }
        int n = 0;
        T[] TArray = objectArray;
        Entry entry = this.header.next;
        while (entry != this.header) {
            TArray[n++] = entry.element;
            entry = entry.next;
        }
        if (objectArray.length > this.size) {
            objectArray[this.size] = null;
        }
        return objectArray;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        objectOutputStream.writeInt(this.size);
        Entry entry = this.header.next;
        while (entry != this.header) {
            objectOutputStream.writeObject(entry.element);
            entry = entry.next;
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.header = new Entry(null, null, null);
        this.header.next = this.header.previous = this.header;
        for (int i = 0; i < n; ++i) {
            this.addBefore(objectInputStream.readObject(), this.header);
        }
    }

    static /* synthetic */ Entry access$000(LinkedList linkedList) {
        return linkedList.header;
    }

    static /* synthetic */ int access$100(LinkedList linkedList) {
        return linkedList.size;
    }

    static /* synthetic */ Object access$200(LinkedList linkedList, Entry entry) {
        return linkedList.remove(entry);
    }

    static /* synthetic */ Entry access$300(LinkedList linkedList, Object object, Entry entry) {
        return linkedList.addBefore(object, entry);
    }

    private class DescendingIterator
    implements Iterator<E> {
        private final ListItr itr;

        private DescendingIterator() {
            this.itr = new ListItr(LinkedList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.itr.hasPrevious();
        }

        @Override
        public E next() {
            return this.itr.previous();
        }

        @Override
        public void remove() {
            this.itr.remove();
        }
    }

    private class ListItr
    implements ListIterator<E> {
        private Node<E> lastReturned;
        private Node<E> next;
        private int nextIndex;
        private int expectedModCount;

        ListItr(int index) {
            this.expectedModCount = LinkedList.this.modCount;
            this.next = index == LinkedList.this.size ? null : LinkedList.this.node(index);
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < LinkedList.this.size;
        }

        @Override
        public E next() {
            this.checkForComodification();
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.next;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex > 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            if (!this.hasPrevious()) {
                throw new NoSuchElementException();
            }
            this.next = this.next == null ? LinkedList.this.last : this.next.prev;
            this.lastReturned = this.next;
            --this.nextIndex;
            return this.lastReturned.item;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            this.checkForComodification();
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            Node lastNext = this.lastReturned.next;
            LinkedList.this.unlink(this.lastReturned);
            if (this.next == this.lastReturned) {
                this.next = lastNext;
            } else {
                --this.nextIndex;
            }
            this.lastReturned = null;
            ++this.expectedModCount;
        }

        @Override
        public void set(E e) {
            if (this.lastReturned == null) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            this.lastReturned.item = e;
        }

        @Override
        public void add(E e) {
            this.checkForComodification();
            this.lastReturned = null;
            if (this.next == null) {
                LinkedList.this.linkLast(e);
            } else {
                LinkedList.this.linkBefore(e, this.next);
            }
            ++this.nextIndex;
            ++this.expectedModCount;
        }

        @Override
        public void forEachRemaining(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            while (LinkedList.this.modCount == this.expectedModCount && this.nextIndex < LinkedList.this.size) {
                action.accept(this.next.item);
                this.lastReturned = this.next;
                this.next = this.next.next;
                ++this.nextIndex;
            }
            this.checkForComodification();
        }

        final void checkForComodification() {
            if (LinkedList.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

