/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.export;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.logging.Logger;

class FactoryUtil {
    private static final Logger log = Logger.getLogger(FactoryUtil.class.getName());

    private FactoryUtil() {
        throw new UnsupportedOperationException("No instances should be created; stateless utility class");
    }

    static <T> T createInstance(final String className, final Class<T> type) throws IllegalArgumentException {
        if (className == null || className.length() == 0) {
            throw new IllegalArgumentException("className must be specified");
        }
        if (type == null) {
            throw new IllegalArgumentException("type must be specified");
        }
        return AccessController.doPrivileged(new PrivilegedAction<T>(){

            @Override
            public T run() {
                try {
                    ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                    Class<?> clazz = Class.forName(className, false, classLoader);
                    Object obj = clazz.newInstance();
                    try {
                        return type.cast(obj);
                    }
                    catch (ClassCastException cee) {
                        throw new IllegalArgumentException("Specified type " + type.getName() + " is not assignable to " + obj);
                    }
                }
                catch (Exception e) {
                    throw new IllegalArgumentException("Unable to create implemenation: " + className, e);
                }
            }
        });
    }
}

