/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import org.jboss.shrinkwrap.api.ConfigurationBuilder;
import org.jboss.shrinkwrap.api.ExtensionLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Configuration {
    private final ExtensionLoader extensionLoader;
    private final ExecutorService executorService;
    private final Iterable<ClassLoader> classLoaders;

    Configuration(ConfigurationBuilder builder) throws IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException("builder must be specified");
        }
        builder.setDefaults();
        this.extensionLoader = builder.getExtensionLoader();
        this.executorService = builder.getExecutorService();
        Collection<ClassLoader> cls = new ArrayList();
        if (builder.getClassLoaders() instanceof Collection) {
            cls = (Collection)builder.getClassLoaders();
        } else {
            for (ClassLoader cl : builder.getClassLoaders()) {
                cls.add(cl);
            }
        }
        this.classLoaders = Collections.unmodifiableCollection(cls);
    }

    public ExtensionLoader getExtensionLoader() {
        return this.extensionLoader;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    public Iterable<ClassLoader> getClassLoaders() {
        return this.classLoaders;
    }
}

