/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.api.asset;

import java.io.InputStream;
import org.jboss.shrinkwrap.api.asset.ApiTestUtils;
import org.jboss.shrinkwrap.api.asset.ClassAsset;
import org.junit.Assert;
import org.junit.Test;

public class ClassAssetTestCase {
    @Test
    public void shouldBeAbleToReadThisClass() throws Exception {
        Class<ClassAssetTestCase> clazz = ClassAssetTestCase.class;
        ClassAsset asset = new ClassAsset(clazz);
        InputStream io = asset.openStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Loaded class should have the same size", (long)ApiTestUtils.findLengthOfStream(io), (long)ApiTestUtils.findLengthOfClass(clazz));
    }

    @Test
    public void shouldBeAbleAddBootstrapClass() throws Exception {
        Class<Class> bootstrapClass = Class.class;
        ClassAsset asset = new ClassAsset(bootstrapClass);
        InputStream io = asset.openStream();
        Assert.assertNotNull((Object)io);
        Assert.assertEquals((String)"Loaded class should have the same size", (long)ApiTestUtils.findLengthOfStream(io), (long)ApiTestUtils.findLengthOfClass(bootstrapClass));
    }

    @Test
    public void shouldThrowExceptionOnNullClass() throws Exception {
        try {
            new ClassAsset(null);
            Assert.fail((String)"Should have thrown IllegalArgumentException");
        }
        catch (Exception e) {
            Assert.assertEquals((String)"A null clazz argument should result in a IllegalArgumentException", IllegalArgumentException.class, e.getClass());
        }
    }

    @Test
    public void shouldBeAbleToReturnThisClass() throws Exception {
        Class<ClassAssetTestCase> clazz = ClassAssetTestCase.class;
        ClassAsset asset = new ClassAsset(clazz);
        Assert.assertTrue((boolean)clazz.getName().equals(asset.getSource().getName()));
    }
}

