/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.export;

import java.io.File;
import java.net.URISyntaxException;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.impl.base.MemoryMapArchiveImpl;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;

public abstract class ExportTestBase {
    private static final Logger log = Logger.getLogger(ExportTestBase.class.getName());
    protected static final String NAME_ARCHIVE = "testArchive.jar";
    protected static final String NAME_TEST_PROPERTIES = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    protected static final String NAME_TEST_PROPERTIES_2 = "org/jboss/shrinkwrap/impl/base/asset/Test2.properties";
    protected static final Path NESTED_PATH = new BasicPath("nested");
    protected static final String NAME_NESTED_ARCHIVE = "nestedArchive.jar";
    protected static final String NAME_NESTED_ARCHIVE_2 = "nestedArchive2.jar";
    protected static final Asset ASSET_ONE = new ClassLoaderAsset("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
    protected static final Path PATH_ONE = new BasicPath("Test.properties");
    protected static final Asset ASSET_TWO = new ClassLoaderAsset("org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
    protected static final Path PATH_TWO = new BasicPath(NESTED_PATH, "Test2.properties");

    protected File createTempDirectory(String testName) throws Exception {
        File tempDirectoryParent = new File(this.getTarget(), this.getClass().getSimpleName());
        File tempDirectory = new File(tempDirectoryParent, testName);
        log.info("Temp Directory: " + tempDirectory.getCanonicalPath());
        if (tempDirectory.exists()) {
            IOUtil.deleteDirectory((File)tempDirectory);
        }
        Assert.assertTrue((String)"Temp directory should be clear before start", (!tempDirectory.exists() ? 1 : 0) != 0);
        tempDirectory.mkdirs();
        return tempDirectory;
    }

    protected File getTarget() {
        try {
            return new File(new File(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()), "../");
        }
        catch (URISyntaxException urise) {
            throw new RuntimeException("Could not obtain the target URI", urise);
        }
    }

    protected Archive<?> createArchiveWithAssets() {
        MemoryMapArchiveImpl archive = new MemoryMapArchiveImpl(NAME_ARCHIVE);
        this.addContent((Archive<?>)archive);
        return archive;
    }

    protected Archive<?> createArchiveWithNestedArchives() {
        Archive<?> archive = this.createArchiveWithAssets();
        MemoryMapArchiveImpl nestedArchive = new MemoryMapArchiveImpl(NAME_NESTED_ARCHIVE);
        this.addContent((Archive<?>)nestedArchive);
        archive.add((Path)new BasicPath(), (Archive)nestedArchive);
        MemoryMapArchiveImpl nestedArchiveTwo = new MemoryMapArchiveImpl(NAME_NESTED_ARCHIVE_2);
        this.addContent((Archive<?>)nestedArchiveTwo);
        archive.add(NESTED_PATH, (Archive)nestedArchiveTwo);
        return archive;
    }

    protected void addContent(Archive<?> archive) {
        archive.add(PATH_ONE, ASSET_ONE);
        archive.add(PATH_TWO, ASSET_TWO);
    }
}

