/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.File;
import java.net.URL;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Asset;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.spec.donotchange.DummyClassUsedForClassResourceTest;
import org.jboss.shrinkwrap.impl.base.test.ArchiveTestBase;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.ContainerTestRunner;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=ContainerTestRunner.class)
public abstract class DynamicContainerTestBase<T extends Archive<T>>
extends ArchiveTestBase<T> {
    protected abstract Path getResourcePath();

    protected abstract ResourceContainer<T> getResourceContainer();

    protected abstract Path getClassPath();

    protected abstract ClassContainer<T> getClassContainer();

    protected abstract Path getManifestPath();

    protected abstract ManifestContainer<T> getManifestContainer();

    protected abstract Path getLibraryPath();

    protected abstract LibraryContainer<T> getLibraryContainer();

    protected URL getURLForClassResource(String name) {
        return Thread.currentThread().getContextClassLoader().getResource(name);
    }

    protected File getFileForClassResource(String name) throws Exception {
        return new File(this.getURLForClassResource(name).toURI());
    }

    protected Asset getAssetForClassResource(String name) {
        return new ClassLoaderAsset(name);
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestResource() throws Exception {
        this.getManifestContainer().setManifest("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestFile() throws Exception {
        this.getManifestContainer().setManifest(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestURL() throws Exception {
        this.getManifestContainer().setManifest(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testSetManifestAsset() throws Exception {
        this.getManifestContainer().setManifest(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "MANIFEST.FM");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestResource() throws Exception {
        this.getManifestContainer().addManifestResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestFile() throws Exception {
        this.getManifestContainer().addManifestResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getManifestContainer().addManifestResource((Path)targetPath, this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), (Path)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetResource() throws Exception {
        this.getManifestContainer().addManifestResource("Test.txt", "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetFile() throws Exception {
        this.getManifestContainer().addManifestResource("Test.txt", this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetURL() throws Exception {
        this.getManifestContainer().addManifestResource("Test.txt", this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestStringTargetAsset() throws Exception {
        this.getManifestContainer().addManifestResource("Test.txt", this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetResource() throws Exception {
        this.getManifestContainer().addManifestResource((Path)new BasicPath("Test.txt"), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetFile() throws Exception {
        this.getManifestContainer().addManifestResource((Path)new BasicPath("Test.txt"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetURL() throws Exception {
        this.getManifestContainer().addManifestResource((Path)new BasicPath("Test.txt"), this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ManifestContainer.class)
    public void testAddManifestPathTargetAsset() throws Exception {
        this.getManifestContainer().addManifestResource((Path)new BasicPath("Test.txt"), this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getManifestPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceResource() throws Exception {
        this.getResourceContainer().addResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceFile() throws Exception {
        this.getResourceContainer().addResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getResourceContainer().addResource((Path)targetPath, this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), (Path)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetResource() throws Exception {
        this.getResourceContainer().addResource("Test.txt", "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetFile() throws Exception {
        this.getResourceContainer().addResource("Test.txt", this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetURL() throws Exception {
        this.getResourceContainer().addResource("Test.txt", this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourceStringTargetAsset() throws Exception {
        this.getResourceContainer().addResource("Test.txt", this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetResource() throws Exception {
        this.getResourceContainer().addResource((Path)new BasicPath("Test.txt"), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetFile() throws Exception {
        this.getResourceContainer().addResource((Path)new BasicPath("Test.txt"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetURL() throws Exception {
        this.getResourceContainer().addResource((Path)new BasicPath("Test.txt"), this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ResourceContainer.class)
    public void testAddResourcePathTargetAsset() throws Exception {
        this.getResourceContainer().addResource((Path)new BasicPath("Test.txt"), this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getResourcePath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClass() throws Exception {
        this.getClassContainer().addClass(DummyClassUsedForClassResourceTest.class);
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddClasses() throws Exception {
        this.getClassContainer().addClasses(new Class[]{DummyClassUsedForClassResourceTest.class});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackage() throws Exception {
        this.getClassContainer().addPackage(DummyClassUsedForClassResourceTest.class.getPackage());
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=ClassContainer.class)
    public void testAddPackageNonRecursive() throws Exception {
        this.getClassContainer().addPackages(false, new Package[]{DummyClassUsedForClassResourceTest.class.getPackage()});
        BasicPath expectedPath = new BasicPath(this.getClassPath(), AssetUtil.getFullPathForClassResource(DummyClassUsedForClassResourceTest.class));
        Assert.assertTrue((String)("A class should be located at " + expectedPath.get()), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryResource() throws Exception {
        this.getLibraryContainer().addLibrary("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryFile() throws Exception {
        this.getLibraryContainer().addLibrary(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getLibraryContainer().addLibrary((Path)targetPath, this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), (Path)targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetResource() throws Exception {
        this.getLibraryContainer().addLibrary("Test.txt", "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetFile() throws Exception {
        this.getLibraryContainer().addLibrary("Test.txt", this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetURL() throws Exception {
        this.getLibraryContainer().addLibrary("Test.txt", this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryStringTargetAsset() throws Exception {
        this.getLibraryContainer().addLibrary("Test.txt", this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetResource() throws Exception {
        this.getLibraryContainer().addLibrary((Path)new BasicPath("Test.txt"), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetFile() throws Exception {
        this.getLibraryContainer().addLibrary((Path)new BasicPath("Test.txt"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetURL() throws Exception {
        this.getLibraryContainer().addLibrary((Path)new BasicPath("Test.txt"), this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryPathTargetAsset() throws Exception {
        this.getLibraryContainer().addLibrary((Path)new BasicPath("Test.txt"), this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath testPath = new BasicPath(this.getLibraryPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }

    @Test
    @ArchiveType(value=LibraryContainer.class)
    public void testAddLibraryArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getLibraryContainer().addLibrary(archive);
        BasicPath testPath = new BasicPath(this.getLibraryPath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((Path)testPath));
    }
}

