/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.Test;

public abstract class DynamicEnterpriseContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    protected abstract Path getModulePath();

    protected abstract Path getApplicationPath();

    protected abstract EnterpriseContainer<T> getEnterpriseContainer();

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResource() throws Exception {
        this.getEnterpriseContainer().setApplicationXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLFile() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLURL() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLAsset() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addApplicationResource((Path)targetPath, this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), (Path)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("Test.txt", "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("Test.txt", this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetURL() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("Test.txt", this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetAsset() throws Exception {
        this.getEnterpriseContainer().addApplicationResource("Test.txt", this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetResource() throws Exception {
        this.getEnterpriseContainer().addApplicationResource((Path)new BasicPath("Test.txt"), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetFile() throws Exception {
        this.getEnterpriseContainer().addApplicationResource((Path)new BasicPath("Test.txt"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetURL() throws Exception {
        this.getEnterpriseContainer().addApplicationResource((Path)new BasicPath("Test.txt"), this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetAsset() throws Exception {
        this.getEnterpriseContainer().addApplicationResource((Path)new BasicPath("Test.txt"), this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleResource() throws Exception {
        this.getEnterpriseContainer().addModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleFile() throws Exception {
        this.getEnterpriseContainer().addModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addModule((Path)targetPath, this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), (Path)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getEnterpriseContainer().addModule(archive);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((Path)expectedPath));
    }
}

