/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.InputStream;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.impl.base.importer.SecurityActions;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipContentAssertionDelegate {
    private static final String EXISTING_ZIP_RESOURCE = "org/jboss/shrinkwrap/impl/base/importer/test.zip";
    private static final String EXPECTED_EMPTY_DIR = "empty_dir/";
    private static final String EXPECTED_NESTED_EMPTY_DIR = "parent/empty_dir/";

    public File getExistingZipResource() throws URISyntaxException {
        return new File(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_ZIP_RESOURCE).toURI());
    }

    public void assertContent(Archive<?> importedArchive, File originalSource) throws Exception {
        Assert.assertFalse((String)"Should have imported something", (boolean)importedArchive.getContent().isEmpty());
        ZipFile testZip = new ZipFile(originalSource);
        ArrayList<? extends ZipEntry> entries = Collections.list(testZip.entries());
        Assert.assertFalse((String)"Test zip should contain data", (boolean)entries.isEmpty());
        Assert.assertEquals((String)"Should have imported all files and directories", (int)entries.size(), (int)importedArchive.getContent().size());
        boolean containsEmptyDir = false;
        boolean containsEmptyNestedDir = false;
        for (ZipEntry zipEntry : entries) {
            if (zipEntry.isDirectory()) {
                if (zipEntry.getName().equals(EXPECTED_EMPTY_DIR)) {
                    containsEmptyDir = true;
                }
                if (!zipEntry.getName().equals(EXPECTED_NESTED_EMPTY_DIR)) continue;
                containsEmptyNestedDir = true;
                continue;
            }
            Assert.assertTrue((String)("Importer should have imported " + zipEntry.getName() + " from " + originalSource), (boolean)importedArchive.contains((ArchivePath)new BasicPath(zipEntry.getName())));
            byte[] originalContent = IOUtil.asByteArray((InputStream)testZip.getInputStream(zipEntry));
            byte[] importedContent = IOUtil.asByteArray((InputStream)importedArchive.get((ArchivePath)new BasicPath(zipEntry.getName())).getAsset().openStream());
            Assert.assertTrue((String)("The content of " + zipEntry.getName() + " should be equal to the imported content"), (boolean)Arrays.equals(importedContent, originalContent));
        }
        Assert.assertTrue((String)"Empty directory not imported", (boolean)containsEmptyDir);
        Assert.assertTrue((String)"Empty nested directory not imported", (boolean)containsEmptyNestedDir);
    }
}

