/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ArchiveImportException;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.asset.ClassLoaderAsset;
import org.jboss.shrinkwrap.impl.base.importer.ZipContentAssertionDelegate;
import org.jboss.shrinkwrap.impl.base.io.IOUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Test;

public class ZipImporterImplTestCase {
    private static final Logger log = Logger.getLogger(ZipImporterImplTestCase.class.getName());
    private static final String EXISTING_RESOURCE = "org/jboss/shrinkwrap/impl/base/asset/Test.properties";
    private static final ZipContentAssertionDelegate delegate = new ZipContentAssertionDelegate();

    @Test
    public void shouldBeAbleToimportZipFile() throws Exception {
        File testFile = delegate.getExistingZipResource();
        ZipFile testZip = new ZipFile(testFile);
        Archive archive = (Archive)((ZipImporter)ShrinkWrap.create((String)"test.jar", ZipImporter.class)).importZip(testZip).as(JavaArchive.class);
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        delegate.assertContent(archive, testFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToImportAddAndExport() throws Exception {
        Archive archive;
        File testFile = delegate.getExistingZipResource();
        ZipInputStream stream = new ZipInputStream(new FileInputStream(testFile));
        try {
            archive = (Archive)((ZipImporter)ShrinkWrap.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
        }
        finally {
            stream.close();
        }
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        archive.add((Asset)new ClassLoaderAsset(EXISTING_RESOURCE), (ArchivePath)new BasicPath("test.properties"));
        File tempFile = new File("target/test.zip");
        tempFile.deleteOnExit();
        InputStream zipStream = ((ZipExporter)archive.as(ZipExporter.class)).exportZip();
        IOUtil.copyWithClose((InputStream)zipStream, (OutputStream)new FileOutputStream(tempFile));
        delegate.assertContent(archive, tempFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void shouldBeAbleToImportZipInputStream() throws Exception {
        Archive archive;
        File testFile = delegate.getExistingZipResource();
        ZipInputStream stream = new ZipInputStream(new FileInputStream(testFile));
        try {
            archive = (Archive)((ZipImporter)ShrinkWrap.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
        }
        finally {
            stream.close();
        }
        Assert.assertNotNull((String)"Should not return a null archive", (Object)archive);
        delegate.assertContent(archive, testFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromStream() throws Exception {
        ZipInputStream stream = new ZipInputStream(new InputStream(){

            public int read() throws IOException {
                throw new IOException("Mock exception");
            }
        });
        try {
            ((ZipImporter)ShrinkWrap.create((String)"test.jar", ZipImporter.class)).importZip(stream).as(JavaArchive.class);
        }
        finally {
            stream.close();
        }
    }

    @Test(expected=ArchiveImportException.class)
    public void shouldThrowExceptionOnErrorInImportFromFile() throws Exception {
        File testFile = delegate.getExistingZipResource();
        ZipFile testZip = new ZipFile(testFile){

            @Override
            public Enumeration<? extends ZipEntry> entries() {
                throw new IllegalStateException("mock  exception");
            }
        };
        ((ZipImporter)ShrinkWrap.create((String)"test.jar", ZipImporter.class)).importZip(testZip).as(JavaArchive.class);
    }
}

