/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.Configuration;
import org.jboss.shrinkwrap.api.Filter;
import org.jboss.shrinkwrap.api.Filters;
import org.jboss.shrinkwrap.api.Node;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.NamedAsset;
import org.jboss.shrinkwrap.api.exporter.StreamExporter;
import org.jboss.shrinkwrap.api.formatter.Formatter;
import org.jboss.shrinkwrap.api.formatter.Formatters;
import org.jboss.shrinkwrap.impl.base.Validate;
import org.jboss.shrinkwrap.impl.base.asset.ArchiveAsset;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.spi.Configurable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ArchiveBase<T extends Archive<T>>
implements Archive<T>,
Configurable {
    private static final Logger log = Logger.getLogger(ArchiveBase.class.getName());
    private final String name;
    private final Configuration configuration;

    protected ArchiveBase(String name, Configuration configuration) throws IllegalArgumentException {
        Validate.notNullOrEmpty(name, "name must be specified");
        Validate.notNull(configuration, "configuration must be specified");
        this.name = name;
        this.configuration = configuration;
    }

    public T add(Asset asset, String target) throws IllegalArgumentException {
        Validate.notNullOrEmpty(target, "target must be specified");
        Validate.notNull(asset, "asset must be specified");
        BasicPath path = new BasicPath(target);
        return (T)this.add(asset, path);
    }

    public T add(Asset asset, String target, String name) throws IllegalArgumentException {
        Validate.notNull(target, "target must be specified");
        ArchivePath path = ArchivePaths.create((String)target);
        return this.add(asset, path, name);
    }

    public T add(Asset asset, ArchivePath path, String name) {
        Validate.notNull(path, "No path was specified");
        Validate.notNullOrEmpty(name, "No target name name was specified");
        Validate.notNull(asset, "No asset was was specified");
        BasicPath resolvedPath = new BasicPath(path, name);
        return (T)this.add(asset, resolvedPath);
    }

    public Node get(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "No path was specified");
        BasicPath realPath = new BasicPath(path);
        return this.get(realPath);
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, String path) {
        Validate.notNull(path, "Path must be specified");
        return this.getAsType(type, ArchivePaths.create((String)path));
    }

    public <X extends Archive<X>> Collection<X> getAsType(Class<X> type, Filter<ArchivePath> filter) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(filter, "Filter must be specified");
        ArrayList<X> archives = new ArrayList<X>();
        Map matches = this.getContent(filter);
        for (ArchivePath path : matches.keySet()) {
            archives.add(this.getAsType(type, path));
        }
        return archives;
    }

    public <X extends Archive<X>> X getAsType(Class<X> type, ArchivePath path) {
        Validate.notNull(type, "Type must be specified");
        Validate.notNull(path, "ArchivePath must be specified");
        Node content = this.get(path);
        if (content == null) {
            return null;
        }
        Asset asset = content.getAsset();
        if (asset == null) {
            return null;
        }
        if (asset instanceof ArchiveAsset) {
            ArchiveAsset archiveAsset = (ArchiveAsset)asset;
            return (X)((Archive)archiveAsset.getArchive().as(type));
        }
        throw new IllegalArgumentException("Found content does not contain a Archive, " + asset);
    }

    public T add(Archive<?> archive, ArchivePath path, Class<? extends StreamExporter> exporter) {
        Validate.notNull(path, "No path was specified");
        Validate.notNull(archive, "No archive was specified");
        Validate.notNull(exporter, "No exporter was specified");
        String archiveName = archive.getName();
        BasicPath contentPath = new BasicPath(path, archiveName);
        ArchiveAsset archiveAsset = new ArchiveAsset(archive, exporter);
        return (T)this.add(archiveAsset, contentPath);
    }

    public T add(NamedAsset namedAsset) {
        Validate.notNull(namedAsset, "No named asset was specified");
        return this.add((Asset)namedAsset, namedAsset.getName());
    }

    public T addDirectory(String path) throws IllegalArgumentException {
        Validate.notNullOrEmpty(path, "path must be specified");
        return (T)this.addDirectory(ArchivePaths.create((String)path));
    }

    public T addDirectories(ArchivePath ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        for (ArchivePath path : paths) {
            this.addDirectory(path);
        }
        return this.covariantReturn();
    }

    public T addDirectories(String ... paths) throws IllegalArgumentException {
        Validate.notNull(paths, "paths must be specified");
        ArrayList<ArchivePath> pathsCollection = new ArrayList<ArchivePath>(paths.length);
        for (String path : paths) {
            pathsCollection.add(ArchivePaths.create((String)path));
        }
        return this.addDirectories(pathsCollection.toArray(new ArchivePath[0]));
    }

    public final String getName() {
        return this.name;
    }

    public T merge(Archive<?> source) throws IllegalArgumentException {
        return this.merge(source, new BasicPath());
    }

    public T merge(Archive<?> source, Filter<ArchivePath> filter) throws IllegalArgumentException {
        return this.merge(source, new BasicPath(), filter);
    }

    public T merge(Archive<?> source, ArchivePath path) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        return this.merge(source, path, (Filter<ArchivePath>)Filters.includeAll());
    }

    public T merge(Archive<?> source, String path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create((String)path), filter);
    }

    public T merge(Archive<?> source, String path) throws IllegalArgumentException {
        Validate.notNull(path, "path must be specified");
        return this.merge(source, ArchivePaths.create((String)path));
    }

    public T merge(Archive<?> source, ArchivePath path, Filter<ArchivePath> filter) throws IllegalArgumentException {
        Validate.notNull(source, "No source archive was specified");
        Validate.notNull(path, "No path was specified");
        Validate.notNull(filter, "No filter was specified");
        Map sourceContent = source.getContent();
        Validate.notNull(sourceContent, "Source archive content can not be null.");
        for (Map.Entry contentEntry : sourceContent.entrySet()) {
            Node node = (Node)contentEntry.getValue();
            BasicPath nodePath = new BasicPath(path, (ArchivePath)contentEntry.getKey());
            if (!filter.include((Object)nodePath)) continue;
            if (node.getAsset() == null) {
                this.addDirectory(nodePath);
                continue;
            }
            this.add(node.getAsset(), nodePath);
        }
        return this.covariantReturn();
    }

    public <TYPE extends Assignable> TYPE as(Class<TYPE> clazz) {
        Validate.notNull(clazz, "Class must be specified");
        return (TYPE)this.configuration.getExtensionLoader().load(clazz, (Archive)this);
    }

    public String toString() {
        return this.toString((Formatter)Formatters.SIMPLE);
    }

    public String toString(boolean verbose) {
        return verbose ? this.toString((Formatter)Formatters.VERBOSE) : this.toString();
    }

    public String toString(Formatter formatter) throws IllegalArgumentException {
        if (formatter == null) {
            throw new IllegalArgumentException("Formatter must be specified");
        }
        return formatter.format((Archive)this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getContent() == null ? 0 : ((Object)this.getContent()).hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ArchiveBase)) {
            return false;
        }
        ArchiveBase other = (ArchiveBase)obj;
        if (this.getContent() == null ? other.getContent() != null : !((Object)this.getContent()).equals(other.getContent())) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    protected abstract Class<T> getActualClass();

    protected final T covariantReturn() {
        try {
            return (T)((Archive)this.getActualClass().cast(this));
        }
        catch (ClassCastException cce) {
            log.log(Level.SEVERE, "The class specified by getActualClass is not a valid assignment target for this instance; developer error");
            throw cce;
        }
    }
}

