/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base;

import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Enumeration;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Assignable;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.UnknownExtensionTypeException;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.AssignableBase;
import org.jboss.shrinkwrap.impl.base.MockArchive;
import org.jboss.shrinkwrap.impl.base.ServiceExtensionLoader;
import org.jboss.shrinkwrap.impl.base.TestSecurityActions;
import org.junit.Ignore;
import org.junit.Test;

public class ServiceExtensionLoaderTestCase {
    @Test
    public void shouldBeAbleToLoadExtension() throws Exception {
        Extension extension = (Extension)this.createLoaderUsingTccl().load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl.class ? 1 : 0) != 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void useTcclInLoading() {
        ServiceExtensionLoader loader = this.createLoaderUsingTccl();
        JavaArchive archive = (JavaArchive)ShrinkWrap.create(JavaArchive.class);
        boolean gotExpectedError = false;
        try {
            loader.load(MockArchive.class, (Archive)archive);
        }
        catch (UnknownExtensionTypeException uete) {
            gotExpectedError = true;
        }
        TestCase.assertTrue((String)"Test setup is broken, should not be able to load mock archive", (boolean)gotExpectedError);
        MockArchiveDescriptorNameAdjustingClassLoader cl = new MockArchiveDescriptorNameAdjustingClassLoader();
        ClassLoader originalCl = TestSecurityActions.getThreadContextClassLoader();
        ServiceExtensionLoaderTestCase.setTccl(cl);
        try {
            Archive loaded = (Archive)loader.load(MockArchive.class, (Archive)archive);
            TestCase.assertNotNull((String)"Archive should have been loaded", (Object)loaded);
        }
        finally {
            ServiceExtensionLoaderTestCase.setTccl(originalCl);
        }
    }

    @Test
    public void shouldBeAbleToOverrideExtension() throws Exception {
        Extension extension = (Extension)this.createLoaderUsingTccl().addOverride(Extension.class, ExtensionImpl2.class).load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertNotNull((Object)extension);
        Assert.assertTrue((extension.getClass() == ExtensionImpl2.class ? 1 : 0) != 0);
    }

    @Test
    public void shouldBePlacedInCacheAfterLoad() throws Exception {
        ServiceExtensionLoader loader = this.createLoaderUsingTccl();
        loader.load(Extension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
        Assert.assertTrue((String)"Should be placed in cache", (boolean)loader.isCached(Extension.class));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnMissingExtension() throws Exception {
        this.createLoaderUsingTccl().load(MissingExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
    }

    @Test(expected=RuntimeException.class)
    public void shouldThrowExceptionOnWrongImplType() throws Exception {
        this.createLoaderUsingTccl().load(WrongImplExtension.class, (Archive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar"));
    }

    private static void setTccl(final ClassLoader cl) {
        assert (cl != null) : "CL must be supplied.";
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    private ServiceExtensionLoader createLoaderUsingTccl() {
        ArrayList<ClassLoader> cls = new ArrayList<ClassLoader>(1);
        cls.add(TestSecurityActions.getThreadContextClassLoader());
        return new ServiceExtensionLoader(cls);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MockArchiveDescriptorNameAdjustingClassLoader
    extends URLClassLoader {
        private static final String MOCK_ARCHIVE_DESCRIPTOR_NAME = "META-INF/services/" + MockArchive.class.getName();
        private static final String MOCK_ARCHIVE_DESCRIPTOR_SUFFIX = "-MockClassLoader";

        public MockArchiveDescriptorNameAdjustingClassLoader() {
            super(new URL[0], TestSecurityActions.getThreadContextClassLoader());
        }

        @Override
        public Enumeration<URL> getResources(String name) throws IOException {
            if (name.equals(MOCK_ARCHIVE_DESCRIPTOR_NAME)) {
                name = name + MOCK_ARCHIVE_DESCRIPTOR_SUFFIX;
            }
            return super.getResources(name);
        }
    }

    public static interface MissingExtension
    extends Assignable {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl2
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl2(Archive<?> archive) {
            super(archive);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtensionImpl
    extends AssignableBase<Archive<?>>
    implements Extension {
        public ExtensionImpl(Archive<?> archive) {
            super(archive);
        }
    }

    public static interface Extension
    extends Assignable {
    }

    public static interface WrongImplExtension
    extends Assignable {
    }
}

