/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.test;

import java.io.File;
import junit.framework.Assert;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ArchivePath;
import org.jboss.shrinkwrap.api.ArchivePaths;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.impl.base.asset.AssetUtil;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicContainerTestBase;
import org.junit.Test;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class DynamicEnterpriseContainerTestBase<T extends Archive<T>>
extends DynamicContainerTestBase<T> {
    protected abstract ArchivePath getModulePath();

    protected abstract ArchivePath getApplicationPath();

    protected abstract EnterpriseContainer<T> getEnterpriseContainer();

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResource() throws Exception {
        this.getEnterpriseContainer().setApplicationXML("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLResourceInPackage() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLFile() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLURL() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testSetApplicationXMLAsset() throws Exception {
        this.getEnterpriseContainer().setApplicationXML(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "application.xml");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResource() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetResource() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetURL() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationStringTargetAsset() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.txt");
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetResource() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetURL() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationPathTargetAsset() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.txt"));
        BasicPath expectedPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddAplicationResourcePackage() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties");
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackages() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResources(AssetUtil.class.getPackage(), new String[]{"Test.properties", "Test2.properties"});
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath testPath2 = new BasicPath(this.getApplicationPath(), "org/jboss/shrinkwrap/impl/base/asset/Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
        Assert.assertTrue((String)("Archive should contain " + testPath2), (boolean)this.getArchive().contains((ArchivePath)testPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackageStringTarget() throws Exception {
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties", "Test.txt");
        BasicPath testPath = new BasicPath(this.getApplicationPath(), "Test.txt");
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddApplicationResourcePackagePathTarget() throws Exception {
        ArchivePath targetPath = ArchivePaths.create((String)"Test.txt");
        this.getEnterpriseContainer().addAsApplicationResource(AssetUtil.class.getPackage(), "Test.properties", targetPath);
        BasicPath testPath = new BasicPath(this.getApplicationPath(), targetPath);
        Assert.assertTrue((String)("Archive should contain " + testPath), (boolean)this.getArchive().contains((ArchivePath)testPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleResource() throws Exception {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesResources() throws Exception {
        this.getEnterpriseContainer().addAsModules(new String[]{"org/jboss/shrinkwrap/impl/base/asset/Test.properties", "org/jboss/shrinkwrap/impl/base/asset/Test2.properties"});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), "Test.properties");
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), "Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath1), (boolean)this.getArchive().contains((ArchivePath)expectedPath1));
        Assert.assertTrue((String)("Archive should contain " + expectedPath2), (boolean)this.getArchive().contains((ArchivePath)expectedPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesFiles() throws Exception {
        this.getEnterpriseContainer().addAsModules(new File[]{this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test2.properties")});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), "Test.properties");
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), "Test2.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath1), (boolean)this.getArchive().contains((ArchivePath)expectedPath1));
        Assert.assertTrue((String)("Archive should contain " + expectedPath2), (boolean)this.getArchive().contains((ArchivePath)expectedPath2));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleURL() throws Exception {
        BasicPath targetPath = new BasicPath("Test.properties");
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)targetPath);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), (ArchivePath)targetPath);
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetResource() throws Exception {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetURL() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleStringTargetAsset() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), "Test.properties");
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetResource() throws Exception {
        this.getEnterpriseContainer().addAsModule("org/jboss/shrinkwrap/impl/base/asset/Test.properties", (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetFile() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getFileForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetURL() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getURLForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulePathTargetAsset() throws Exception {
        this.getEnterpriseContainer().addAsModule(this.getAssetForClassResource("org/jboss/shrinkwrap/impl/base/asset/Test.properties"), (ArchivePath)new BasicPath("Test.properties"));
        BasicPath expectedPath = new BasicPath(this.getModulePath(), "Test.properties");
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModuleArchive() throws Exception {
        Archive archive = this.createNewArchive();
        this.getEnterpriseContainer().addAsModule(archive);
        BasicPath expectedPath = new BasicPath(this.getModulePath(), archive.getName());
        Assert.assertTrue((String)("Archive should contain " + expectedPath), (boolean)this.getArchive().contains((ArchivePath)expectedPath));
    }

    @Test
    @ArchiveType(value=EnterpriseContainer.class)
    public void testAddModulesArchives() throws Exception {
        Archive archive1 = this.createNewArchive();
        Archive archive2 = this.createNewArchive();
        this.getEnterpriseContainer().addAsModules(new Archive[]{archive1, archive2});
        BasicPath expectedPath1 = new BasicPath(this.getModulePath(), archive1.getName());
        BasicPath expectedPath2 = new BasicPath(this.getModulePath(), archive2.getName());
        Assert.assertTrue((String)("Archive should contain " + expectedPath1), (boolean)this.getArchive().contains((ArchivePath)expectedPath1));
        Assert.assertTrue((String)("Archive should contain " + expectedPath2), (boolean)this.getArchive().contains((ArchivePath)expectedPath2));
    }
}

