/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.exporter.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.importer.ZipImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ArchiveJarInputStream;
import org.jboss.shrinkwrap.impl.base.exporter.zip.ArchiveJarZipInputStream;
import org.junit.Assert;
import org.junit.Test;

public class VirtualJarFileInputStreamTestCase {
    @Test
    public void testClass() {
        Archive archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addClass(VirtualJarFileInputStreamTestCase.class);
        InputStream in = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
        Archive imported = (Archive)ShrinkWrap.create(JavaArchive.class);
        ((ZipImporter)imported.as(ZipImporter.class)).importFrom(in);
    }

    @Test
    public void testSimple() throws IOException {
        int c;
        Archive archive = ((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).add((Asset)new StringAsset("Hello world"), "test.txt");
        ArchiveJarZipInputStream virtualIn = new ArchiveJarZipInputStream(new ArchiveJarInputStream(archive));
        JarInputStream in = new JarInputStream((InputStream)virtualIn);
        JarEntry entry = in.getNextJarEntry();
        Assert.assertEquals((Object)"test.txt", (Object)entry.getName());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((c = in.read()) != -1) {
            out.write(c);
        }
        String contents = out.toString();
        Assert.assertEquals((Object)"Hello world", (Object)contents);
    }

    @Test
    public void testImport() throws IOException {
        Archive archive = ((JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"test.jar")).addAsDirectory("test")).add((Asset)new StringAsset("Hello world"), "test.txt");
        InputStream in = ((ZipExporter)archive.as(ZipExporter.class)).exportAsInputStream();
        Archive imported = (Archive)ShrinkWrap.create(JavaArchive.class);
        ((ZipImporter)imported.as(ZipImporter.class)).importFrom(in);
    }
}

