/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.importer;

import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.importer.ExplodedImporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.impl.base.importer.SecurityActions;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.junit.Assert;
import org.junit.Test;

public class ExplodedImporterTestCase {
    private static final String EXISTING_DIRECTORY_RESOURCE = "exploded_import_test";
    private static final String EXISTING_FILE_RESOURCE = "exploded_import_test/Test.properties";

    @Test
    public void shouldBeAbleToImportADriectory() throws Exception {
        Archive archive = (Archive)((ExplodedImporter)Archives.create((String)"test.jar", ExplodedImporter.class)).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_DIRECTORY_RESOURCE).toURI().getPath()).as(JavaArchive.class);
        Assert.assertTrue((String)"Root files should be imported", (boolean)archive.contains((Path)new BasicPath("/Test.properties")));
        Assert.assertTrue((String)"Nested files should be imported", (boolean)archive.contains((Path)new BasicPath("/META-INF/MANIFEST.FM")));
        Assert.assertTrue((String)"Nested files should be imported", (boolean)archive.contains((Path)new BasicPath("/org/jboss/Test.properties")));
    }

    @Test(expected=IllegalArgumentException.class)
    public void shouldThrowExceptionIfImportingAFile() throws Exception {
        ((ExplodedImporter)Archives.create((String)"test.jar", ExplodedImporter.class)).importDirectory(SecurityActions.getThreadContextClassLoader().getResource(EXISTING_FILE_RESOURCE).toURI().getPath());
    }
}

