/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.shrinkwrap.impl.base.spec;

import java.util.UUID;
import org.jboss.shrinkwrap.api.Archives;
import org.jboss.shrinkwrap.api.Path;
import org.jboss.shrinkwrap.api.container.ClassContainer;
import org.jboss.shrinkwrap.api.container.EnterpriseContainer;
import org.jboss.shrinkwrap.api.container.LibraryContainer;
import org.jboss.shrinkwrap.api.container.ManifestContainer;
import org.jboss.shrinkwrap.api.container.ResourceContainer;
import org.jboss.shrinkwrap.api.spec.EnterpriseArchive;
import org.jboss.shrinkwrap.impl.base.path.BasicPath;
import org.jboss.shrinkwrap.impl.base.test.ArchiveType;
import org.jboss.shrinkwrap.impl.base.test.DynamicEnterpriseContainerTestBase;
import org.junit.After;
import org.junit.Before;

@ArchiveType(value=EnterpriseArchive.class)
public class EnterpriseArchiveImplTestCase
extends DynamicEnterpriseContainerTestBase<EnterpriseArchive> {
    private static final Path PATH_APPLICATION = new BasicPath("META-INF");
    private static final Path PATH_LIBRARY = new BasicPath("lib");
    private static final Path PATH_MODULE = new BasicPath("/");
    private EnterpriseArchive archive;

    @Before
    public void createEnterpriseArchive() throws Exception {
        this.archive = this.createNewArchive();
    }

    @Override
    @After
    public void ls() {
        System.out.println("test@jboss:/$ ls -l " + this.archive.getName());
        System.out.println(this.archive.toString(true));
    }

    @Override
    protected EnterpriseArchive getArchive() {
        return this.archive;
    }

    protected EnterpriseArchive createNewArchive() {
        return (EnterpriseArchive)Archives.create((String)(UUID.randomUUID().toString() + ".jar"), EnterpriseArchive.class);
    }

    @Override
    protected ClassContainer<EnterpriseArchive> getClassContainer() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected Path getClassPath() {
        throw new UnsupportedOperationException("EnterpriseArchives do not support classes");
    }

    @Override
    protected LibraryContainer<EnterpriseArchive> getLibraryContainer() {
        return this.archive;
    }

    @Override
    protected Path getManifestPath() {
        return PATH_APPLICATION;
    }

    @Override
    protected Path getResourcePath() {
        return PATH_APPLICATION;
    }

    @Override
    protected Path getLibraryPath() {
        return PATH_LIBRARY;
    }

    @Override
    protected ManifestContainer<EnterpriseArchive> getManifestContainer() {
        return this.getArchive();
    }

    @Override
    protected ResourceContainer<EnterpriseArchive> getResourceContainer() {
        return this.getArchive();
    }

    @Override
    protected Path getModulePath() {
        return PATH_MODULE;
    }

    @Override
    protected Path getApplicationPath() {
        return PATH_APPLICATION;
    }

    @Override
    protected EnterpriseContainer<EnterpriseArchive> getEnterpriseContainer() {
        return this.getArchive();
    }
}

